'use strict';

exports.__esModule = true;

var _extends2 = require('babel-runtime/helpers/extends');

var _extends3 = _interopRequireDefault(_extends2);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _createReactClass = require('create-react-class');

var _createReactClass2 = _interopRequireDefault(_createReactClass);

var _KeyCode = require('rc-util/lib/KeyCode');

var _KeyCode2 = _interopRequireDefault(_KeyCode);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _util = require('./util');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

/* eslint react/no-is-mounted:0 */

var MenuItem = (0, _createReactClass2['default'])({
  displayName: 'MenuItem',

  propTypes: {
    rootPrefixCls: _propTypes2['default'].string,
    eventKey: _propTypes2['default'].string,
    active: _propTypes2['default'].bool,
    children: _propTypes2['default'].any,
    selectedKeys: _propTypes2['default'].array,
    disabled: _propTypes2['default'].bool,
    title: _propTypes2['default'].string,
    onItemHover: _propTypes2['default'].func,
    onSelect: _propTypes2['default'].func,
    onClick: _propTypes2['default'].func,
    onDeselect: _propTypes2['default'].func,
    parentMenu: _propTypes2['default'].object,
    onDestroy: _propTypes2['default'].func,
    onMouseEnter: _propTypes2['default'].func,
    onMouseLeave: _propTypes2['default'].func
  },

  getDefaultProps: function getDefaultProps() {
    return {
      onSelect: _util.noop,
      onMouseEnter: _util.noop,
      onMouseLeave: _util.noop
    };
  },
  componentWillUnmount: function componentWillUnmount() {
    var props = this.props;
    if (props.onDestroy) {
      props.onDestroy(props.eventKey);
    }
  },
  onKeyDown: function onKeyDown(e) {
    var keyCode = e.keyCode;
    if (keyCode === _KeyCode2['default'].ENTER) {
      this.onClick(e);
      return true;
    }
  },
  onMouseLeave: function onMouseLeave(e) {
    var _props = this.props,
        eventKey = _props.eventKey,
        onItemHover = _props.onItemHover,
        onMouseLeave = _props.onMouseLeave;

    onItemHover({
      key: eventKey,
      hover: false
    });
    onMouseLeave({
      key: eventKey,
      domEvent: e
    });
  },
  onMouseEnter: function onMouseEnter(e) {
    var _props2 = this.props,
        eventKey = _props2.eventKey,
        onItemHover = _props2.onItemHover,
        onMouseEnter = _props2.onMouseEnter;

    onItemHover({
      key: eventKey,
      hover: true
    });
    onMouseEnter({
      key: eventKey,
      domEvent: e
    });
  },
  onClick: function onClick(e) {
    var _props3 = this.props,
        eventKey = _props3.eventKey,
        multiple = _props3.multiple,
        onClick = _props3.onClick,
        onSelect = _props3.onSelect,
        onDeselect = _props3.onDeselect;

    var selected = this.isSelected();
    var info = {
      key: eventKey,
      keyPath: [eventKey],
      item: this,
      domEvent: e
    };
    onClick(info);
    if (multiple) {
      if (selected) {
        onDeselect(info);
      } else {
        onSelect(info);
      }
    } else if (!selected) {
      onSelect(info);
    }
  },
  getPrefixCls: function getPrefixCls() {
    return this.props.rootPrefixCls + '-item';
  },
  getActiveClassName: function getActiveClassName() {
    return this.getPrefixCls() + '-active';
  },
  getSelectedClassName: function getSelectedClassName() {
    return this.getPrefixCls() + '-selected';
  },
  getDisabledClassName: function getDisabledClassName() {
    return this.getPrefixCls() + '-disabled';
  },
  isSelected: function isSelected() {
    return this.props.selectedKeys.indexOf(this.props.eventKey) !== -1;
  },
  render: function render() {
    var _classNames;

    var props = this.props;
    var selected = this.isSelected();
    var className = (0, _classnames2['default'])(this.getPrefixCls(), props.className, (_classNames = {}, _classNames[this.getActiveClassName()] = !props.disabled && props.active, _classNames[this.getSelectedClassName()] = selected, _classNames[this.getDisabledClassName()] = props.disabled, _classNames));
    var attrs = (0, _extends3['default'])({}, props.attribute, {
      title: props.title,
      className: className,
      role: 'menuitem',
      'aria-selected': selected,
      'aria-disabled': props.disabled
    });
    var mouseEvent = {};
    if (!props.disabled) {
      mouseEvent = {
        onClick: this.onClick,
        onMouseLeave: this.onMouseLeave,
        onMouseEnter: this.onMouseEnter
      };
    }
    var style = (0, _extends3['default'])({}, props.style);
    if (props.mode === 'inline') {
      style.paddingLeft = props.inlineIndent * props.level;
    }
    return _react2['default'].createElement(
      'li',
      (0, _extends3['default'])({}, attrs, mouseEvent, {
        style: style
      }),
      props.children
    );
  }
});

MenuItem.isMenuItem = 1;

exports['default'] = MenuItem;
module.exports = exports['default'];