"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _createSuper2 = _interopRequireDefault(require("@babel/runtime/helpers/createSuper"));

var React = _interopRequireWildcard(require("react"));

var _util = require("./util");

var MenuItemGroup = /*#__PURE__*/function (_React$Component) {
  (0, _inherits2.default)(MenuItemGroup, _React$Component);

  var _super = (0, _createSuper2.default)(MenuItemGroup);

  function MenuItemGroup() {
    var _this;

    (0, _classCallCheck2.default)(this, MenuItemGroup);
    _this = _super.apply(this, arguments);

    _this.renderInnerMenuItem = function (item) {
      var _this$props = _this.props,
          renderMenuItem = _this$props.renderMenuItem,
          index = _this$props.index;
      return renderMenuItem(item, index, _this.props.subMenuKey);
    };

    return _this;
  }

  (0, _createClass2.default)(MenuItemGroup, [{
    key: "render",
    value: function render() {
      var props = (0, _extends2.default)({}, this.props);
      var _props$className = props.className,
          className = _props$className === void 0 ? '' : _props$className,
          rootPrefixCls = props.rootPrefixCls;
      var titleClassName = "".concat(rootPrefixCls, "-item-group-title");
      var listClassName = "".concat(rootPrefixCls, "-item-group-list");
      var title = props.title,
          children = props.children;

      _util.menuAllProps.forEach(function (key) {
        return delete props[key];
      }); // Set onClick to null, to ignore propagated onClick event


      delete props.onClick;
      delete props.direction;
      return React.createElement("li", Object.assign({}, props, {
        className: "".concat(className, " ").concat(rootPrefixCls, "-item-group")
      }), React.createElement("div", {
        className: titleClassName,
        title: typeof title === 'string' ? title : undefined
      }, title), React.createElement("ul", {
        className: listClassName
      }, React.Children.map(children, this.renderInnerMenuItem)));
    }
  }]);
  return MenuItemGroup;
}(React.Component);

MenuItemGroup.isMenuItemGroup = true;
MenuItemGroup.defaultProps = {
  disabled: true
};
var _default = MenuItemGroup;
exports.default = _default;