import _classCallCheck from 'babel-runtime/helpers/classCallCheck';
import _createClass from 'babel-runtime/helpers/createClass';
import _possibleConstructorReturn from 'babel-runtime/helpers/possibleConstructorReturn';
import _inherits from 'babel-runtime/helpers/inherits';
import React from 'react';
import PropTypes from 'prop-types';
import KEYCODE from './KeyCode';

var Options = function (_React$Component) {
  _inherits(Options, _React$Component);

  function Options() {
    var _ref;

    var _temp, _this, _ret;

    _classCallCheck(this, Options);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = Options.__proto__ || Object.getPrototypeOf(Options)).call.apply(_ref, [this].concat(args))), _this), _this.state = {
      goInputText: ''
    }, _this.buildOptionText = function (value) {
      return value + ' ' + _this.props.locale.items_per_page;
    }, _this.changeSize = function (value) {
      _this.props.changeSize(Number(value));
    }, _this.handleChange = function (e) {
      _this.setState({
        goInputText: e.target.value
      });
    }, _this.handleBlur = function () {
      var _this$props = _this.props,
          goButton = _this$props.goButton,
          quickGo = _this$props.quickGo;

      if (goButton) {
        return;
      }
      quickGo(_this.getValidValue());
    }, _this.go = function (e) {
      var goInputText = _this.state.goInputText;

      if (goInputText === '') {
        return;
      }
      if (e.keyCode === KEYCODE.ENTER || e.type === 'click') {
        _this.setState({
          goInputText: ''
        });
        _this.props.quickGo(_this.getValidValue());
      }
    }, _temp), _possibleConstructorReturn(_this, _ret);
  }

  _createClass(Options, [{
    key: 'getValidValue',
    value: function getValidValue() {
      var _state = this.state,
          goInputText = _state.goInputText,
          current = _state.current;

      return isNaN(goInputText) ? current : Number(goInputText);
    }
  }, {
    key: 'render',
    value: function render() {
      var _this2 = this;

      var _props = this.props,
          pageSize = _props.pageSize,
          pageSizeOptions = _props.pageSizeOptions,
          locale = _props.locale,
          rootPrefixCls = _props.rootPrefixCls,
          changeSize = _props.changeSize,
          quickGo = _props.quickGo,
          goButton = _props.goButton,
          selectComponentClass = _props.selectComponentClass,
          buildOptionText = _props.buildOptionText,
          selectPrefixCls = _props.selectPrefixCls,
          disabled = _props.disabled;
      var goInputText = this.state.goInputText;

      var prefixCls = rootPrefixCls + '-options';
      var Select = selectComponentClass;
      var changeSelect = null;
      var goInput = null;
      var gotoButton = null;

      if (!changeSize && !quickGo) {
        return null;
      }

      if (changeSize && Select) {
        var options = pageSizeOptions.map(function (opt, i) {
          return React.createElement(
            Select.Option,
            { key: i, value: opt },
            (buildOptionText || _this2.buildOptionText)(opt)
          );
        });

        changeSelect = React.createElement(
          Select,
          {
            disabled: disabled,
            prefixCls: selectPrefixCls,
            showSearch: false,
            className: prefixCls + '-size-changer',
            optionLabelProp: 'children',
            dropdownMatchSelectWidth: false,
            value: (pageSize || pageSizeOptions[0]).toString(),
            onChange: this.changeSize,
            getPopupContainer: function getPopupContainer(triggerNode) {
              return triggerNode.parentNode;
            }
          },
          options
        );
      }

      if (quickGo) {
        if (goButton) {
          gotoButton = typeof goButton === 'boolean' ? React.createElement(
            'button',
            {
              type: 'button',
              onClick: this.go,
              onKeyUp: this.go,
              disabled: disabled
            },
            locale.jump_to_confirm
          ) : React.createElement(
            'span',
            {
              onClick: this.go,
              onKeyUp: this.go
            },
            goButton
          );
        }
        goInput = React.createElement(
          'div',
          { className: prefixCls + '-quick-jumper' },
          locale.jump_to,
          React.createElement('input', {
            disabled: disabled,
            type: 'text',
            value: goInputText,
            onChange: this.handleChange,
            onKeyUp: this.go,
            onBlur: this.handleBlur
          }),
          locale.page,
          gotoButton
        );
      }

      return React.createElement(
        'li',
        { className: '' + prefixCls },
        changeSelect,
        goInput
      );
    }
  }]);

  return Options;
}(React.Component);

Options.propTypes = {
  disabled: PropTypes.bool,
  changeSize: PropTypes.func,
  quickGo: PropTypes.func,
  selectComponentClass: PropTypes.func,
  current: PropTypes.number,
  pageSizeOptions: PropTypes.arrayOf(PropTypes.string),
  pageSize: PropTypes.number,
  buildOptionText: PropTypes.func,
  locale: PropTypes.object,
  rootPrefixCls: PropTypes.string,
  selectPrefixCls: PropTypes.string,
  goButton: PropTypes.oneOfType([PropTypes.bool, PropTypes.node])
};
Options.defaultProps = {
  pageSizeOptions: ['10', '20', '30', '40']
};


export default Options;