'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var Pager = function Pager(props) {
  var prefixCls = props.rootPrefixCls + '-item';
  var cls = prefixCls + ' ' + prefixCls + '-' + props.page;

  if (props.active) {
    cls = cls + ' ' + prefixCls + '-active';
  }

  if (props.className) {
    cls = cls + ' ' + props.className;
  }

  return _react2["default"].createElement(
    'li',
    { title: props.showTitle ? props.page : null, className: cls, onClick: props.onClick },
    _react2["default"].createElement(
      'a',
      null,
      props.page
    )
  );
};

Pager.propTypes = {
  page: _propTypes2["default"].number,
  active: _propTypes2["default"].bool,
  last: _propTypes2["default"].bool,
  locale: _propTypes2["default"].object,
  className: _propTypes2["default"].string,
  showTitle: _propTypes2["default"].bool,
  rootPrefixCls: _propTypes2["default"].string,
  onClick: _propTypes2["default"].func
};

exports["default"] = Pager;
module.exports = exports['default'];