'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _Pager = require('./Pager');

var _Pager2 = _interopRequireDefault(_Pager);

var _Options = require('./Options');

var _Options2 = _interopRequireDefault(_Options);

var _KeyCode = require('./KeyCode');

var _KeyCode2 = _interopRequireDefault(_KeyCode);

var _zh_CN = require('./locale/zh_CN');

var _zh_CN2 = _interopRequireDefault(_zh_CN);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defaults(obj, defaults) { var keys = Object.getOwnPropertyNames(defaults); for (var i = 0; i < keys.length; i++) { var key = keys[i]; var value = Object.getOwnPropertyDescriptor(defaults, key); if (value && value.configurable && obj[key] === undefined) { Object.defineProperty(obj, key, value); } } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : _defaults(subClass, superClass); }

function noop() {}

var Pagination = function (_React$Component) {
  _inherits(Pagination, _React$Component);

  function Pagination(props) {
    _classCallCheck(this, Pagination);

    var _this = _possibleConstructorReturn(this, _React$Component.call(this, props));

    var hasOnChange = props.onChange !== noop;
    var hasCurrent = 'current' in props;
    if (hasCurrent && !hasOnChange) {
      console.warn('Warning: You provided a `current` prop to a Pagination component without an `onChange` handler. This will render a read-only component.'); // eslint-disable-line
    }

    var current = props.defaultCurrent;
    if ('current' in props) {
      current = props.current;
    }

    var pageSize = props.defaultPageSize;
    if ('pageSize' in props) {
      pageSize = props.pageSize;
    }

    _this.state = {
      current: current,
      _current: current,
      pageSize: pageSize
    };

    ['render', '_handleChange', '_handleKeyUp', '_handleKeyDown', '_changePageSize', '_isValid', '_prev', '_next', '_hasPrev', '_hasNext', '_jumpPrev', '_jumpNext'].forEach(function (method) {
      return _this[method] = _this[method].bind(_this);
    });
    return _this;
  }

  Pagination.prototype.componentWillReceiveProps = function componentWillReceiveProps(nextProps) {
    if ('current' in nextProps) {
      this.setState({
        current: nextProps.current,
        _current: nextProps.current
      });
    }

    if ('pageSize' in nextProps) {
      var newState = {};
      var current = this.state.current;
      var newCurrent = this._calcPage(nextProps.pageSize);
      current = current > newCurrent ? newCurrent : current;
      if (!('current' in nextProps)) {
        newState.current = current;
        newState._current = current;
      }
      newState.pageSize = nextProps.pageSize;
      this.setState(newState);
    }
  };

  // private methods

  Pagination.prototype._calcPage = function _calcPage(p) {
    var pageSize = p;
    if (typeof pageSize === 'undefined') {
      pageSize = this.state.pageSize;
    }
    return Math.floor((this.props.total - 1) / pageSize) + 1;
  };

  Pagination.prototype._isValid = function _isValid(page) {
    return typeof page === 'number' && page >= 1 && page !== this.state.current;
  };

  Pagination.prototype._handleKeyDown = function _handleKeyDown(evt) {
    if (evt.keyCode === _KeyCode2["default"].ARROW_UP || evt.keyCode === _KeyCode2["default"].ARROW_DOWN) {
      evt.preventDefault();
    }
  };

  Pagination.prototype._handleKeyUp = function _handleKeyUp(evt) {
    var _val = evt.target.value;
    var val = void 0;

    if (_val === '') {
      val = _val;
    } else if (isNaN(Number(_val))) {
      val = this.state._current;
    } else {
      val = Number(_val);
    }

    this.setState({
      _current: val
    });

    if (evt.keyCode === _KeyCode2["default"].ENTER) {
      this._handleChange(val);
    } else if (evt.keyCode === _KeyCode2["default"].ARROW_UP) {
      this._handleChange(val - 1);
    } else if (evt.keyCode === _KeyCode2["default"].ARROW_DOWN) {
      this._handleChange(val + 1);
    }
  };

  Pagination.prototype._changePageSize = function _changePageSize(size) {
    var current = this.state.current;
    var newCurrent = this._calcPage(size);
    current = current > newCurrent ? newCurrent : current;
    if (typeof size === 'number') {
      if (!('pageSize' in this.props)) {
        this.setState({
          pageSize: size
        });
      }
      if (!('current' in this.props)) {
        this.setState({
          current: current,
          _current: current
        });
      }
    }
    this.props.onShowSizeChange(current, size);
  };

  Pagination.prototype._handleChange = function _handleChange(p) {
    var page = p;
    if (this._isValid(page)) {
      if (page > this._calcPage()) {
        page = this._calcPage();
      }

      if (!('current' in this.props)) {
        this.setState({
          current: page,
          _current: page
        });
      }

      var pageSize = this.state.pageSize;
      this.props.onChange(page, pageSize);

      return page;
    }

    return this.state.current;
  };

  Pagination.prototype._prev = function _prev() {
    if (this._hasPrev()) {
      this._handleChange(this.state.current - 1);
    }
  };

  Pagination.prototype._next = function _next() {
    if (this._hasNext()) {
      this._handleChange(this.state.current + 1);
    }
  };

  Pagination.prototype._jumpPrev = function _jumpPrev() {
    this._handleChange(Math.max(1, this.state.current - (this.props.showLessItems ? 3 : 5)));
  };

  Pagination.prototype._jumpNext = function _jumpNext() {
    this._handleChange(Math.min(this._calcPage(), this.state.current + (this.props.showLessItems ? 3 : 5)));
  };

  Pagination.prototype._hasPrev = function _hasPrev() {
    return this.state.current > 1;
  };

  Pagination.prototype._hasNext = function _hasNext() {
    return this.state.current < this._calcPage();
  };

  Pagination.prototype.render = function render() {
    var props = this.props;
    var locale = props.locale;

    var prefixCls = props.prefixCls;
    var allPages = this._calcPage();
    var pagerList = [];
    var jumpPrev = null;
    var jumpNext = null;
    var firstPager = null;
    var lastPager = null;

    var pageBufferSize = props.showLessItems ? 1 : 2;
    var _state = this.state,
        current = _state.current,
        pageSize = _state.pageSize;


    if (props.simple) {
      return _react2["default"].createElement(
        'ul',
        { className: prefixCls + ' ' + prefixCls + '-simple ' + props.className },
        _react2["default"].createElement(
          'li',
          {
            title: props.showTitle ? locale.prev_page : null,
            onClick: this._prev,
            className: (this._hasPrev() ? '' : prefixCls + '-disabled') + ' ' + prefixCls + '-prev'
          },
          _react2["default"].createElement('a', null)
        ),
        _react2["default"].createElement(
          'li',
          {
            title: props.showTitle ? this.state.current + '/' + allPages : null,
            className: prefixCls + '-simple-pager'
          },
          _react2["default"].createElement('input', {
            type: 'text',
            value: this.state._current,
            onKeyDown: this._handleKeyDown,
            onKeyUp: this._handleKeyUp,
            onChange: this._handleKeyUp
          }),
          _react2["default"].createElement(
            'span',
            { className: prefixCls + '-slash' },
            '\uFF0F'
          ),
          allPages
        ),
        _react2["default"].createElement(
          'li',
          {
            title: props.showTitle ? locale.next_page : null,
            onClick: this._next,
            className: (this._hasNext() ? '' : prefixCls + '-disabled') + ' ' + prefixCls + '-next'
          },
          _react2["default"].createElement('a', null)
        )
      );
    }

    if (allPages <= 5 + pageBufferSize * 2) {
      for (var i = 1; i <= allPages; i++) {
        var active = this.state.current === i;
        pagerList.push(_react2["default"].createElement(_Pager2["default"], {
          locale: locale,
          rootPrefixCls: prefixCls,
          onClick: this._handleChange.bind(this, i),
          key: i,
          page: i,
          active: active,
          showTitle: props.showTitle
        }));
      }
    } else {
      var prevItemTitle = props.showLessItems ? locale.prev_3 : locale.prev_5;
      var nextItemTitle = props.showLessItems ? locale.next_3 : locale.next_5;
      jumpPrev = _react2["default"].createElement(
        'li',
        {
          title: props.showTitle ? prevItemTitle : null,
          key: 'prev',
          onClick: this._jumpPrev,
          className: prefixCls + '-jump-prev'
        },
        _react2["default"].createElement('a', null)
      );
      jumpNext = _react2["default"].createElement(
        'li',
        {
          title: props.showTitle ? nextItemTitle : null,
          key: 'next',
          onClick: this._jumpNext,
          className: prefixCls + '-jump-next'
        },
        _react2["default"].createElement('a', null)
      );
      lastPager = _react2["default"].createElement(_Pager2["default"], {
        locale: props.locale,
        last: true,
        rootPrefixCls: prefixCls,
        onClick: this._handleChange.bind(this, allPages),
        key: allPages,
        page: allPages,
        active: false,
        showTitle: props.showTitle
      });
      firstPager = _react2["default"].createElement(_Pager2["default"], {
        locale: props.locale,
        rootPrefixCls: prefixCls,
        onClick: this._handleChange.bind(this, 1),
        key: 1,
        page: 1,
        active: false,
        showTitle: props.showTitle
      });

      var left = Math.max(1, current - pageBufferSize);
      var right = Math.min(current + pageBufferSize, allPages);

      if (current - 1 <= pageBufferSize) {
        right = 1 + pageBufferSize * 2;
      }

      if (allPages - current <= pageBufferSize) {
        left = allPages - pageBufferSize * 2;
      }

      for (var _i = left; _i <= right; _i++) {
        var _active = current === _i;
        pagerList.push(_react2["default"].createElement(_Pager2["default"], {
          locale: props.locale,
          rootPrefixCls: prefixCls,
          onClick: this._handleChange.bind(this, _i),
          key: _i,
          page: _i,
          active: _active,
          showTitle: props.showTitle
        }));
      }

      if (current - 1 >= pageBufferSize * 2 && current !== 1 + 2) {
        pagerList[0] = _react2["default"].cloneElement(pagerList[0], {
          className: prefixCls + '-item-after-jump-prev'
        });
        pagerList.unshift(jumpPrev);
      }
      if (allPages - current >= pageBufferSize * 2 && current !== allPages - 2) {
        pagerList[pagerList.length - 1] = _react2["default"].cloneElement(pagerList[pagerList.length - 1], {
          className: prefixCls + '-item-before-jump-next'
        });
        pagerList.push(jumpNext);
      }

      if (left !== 1) {
        pagerList.unshift(firstPager);
      }
      if (right !== allPages) {
        pagerList.push(lastPager);
      }
    }

    var totalText = null;

    if (props.showTotal) {
      totalText = _react2["default"].createElement(
        'span',
        { className: prefixCls + '-total-text' },
        props.showTotal(props.total, [(current - 1) * pageSize + 1, current * pageSize > props.total ? props.total : current * pageSize])
      );
    }

    return _react2["default"].createElement(
      'ul',
      {
        className: prefixCls + ' ' + props.className,
        style: props.style,
        unselectable: 'unselectable'
      },
      totalText,
      _react2["default"].createElement(
        'li',
        {
          title: props.showTitle ? locale.prev_page : null,
          onClick: this._prev,
          className: (this._hasPrev() ? '' : prefixCls + '-disabled') + ' ' + prefixCls + '-prev'
        },
        _react2["default"].createElement('a', null)
      ),
      pagerList,
      _react2["default"].createElement(
        'li',
        {
          title: props.showTitle ? locale.next_page : null,
          onClick: this._next,
          className: (this._hasNext() ? '' : prefixCls + '-disabled') + ' ' + prefixCls + '-next'
        },
        _react2["default"].createElement('a', null)
      ),
      _react2["default"].createElement(_Options2["default"], {
        locale: props.locale,
        rootPrefixCls: prefixCls,
        selectComponentClass: props.selectComponentClass,
        selectPrefixCls: props.selectPrefixCls,
        changeSize: this.props.showSizeChanger ? this._changePageSize.bind(this) : null,
        current: this.state.current,
        pageSize: this.state.pageSize,
        pageSizeOptions: this.props.pageSizeOptions,
        quickGo: this.props.showQuickJumper ? this._handleChange.bind(this) : null
      })
    );
  };

  return Pagination;
}(_react2["default"].Component);

Pagination.propTypes = {
  current: _propTypes2["default"].number,
  defaultCurrent: _propTypes2["default"].number,
  total: _propTypes2["default"].number,
  pageSize: _propTypes2["default"].number,
  defaultPageSize: _propTypes2["default"].number,
  onChange: _propTypes2["default"].func,
  showSizeChanger: _propTypes2["default"].bool,
  showLessItems: _propTypes2["default"].bool,
  onShowSizeChange: _propTypes2["default"].func,
  selectComponentClass: _propTypes2["default"].func,
  showQuickJumper: _propTypes2["default"].bool,
  showTitle: _propTypes2["default"].bool,
  pageSizeOptions: _propTypes2["default"].arrayOf(_propTypes2["default"].string),
  showTotal: _propTypes2["default"].func,
  locale: _propTypes2["default"].object,
  style: _propTypes2["default"].object
};

Pagination.defaultProps = {
  defaultCurrent: 1,
  total: 0,
  defaultPageSize: 10,
  onChange: noop,
  className: '',
  selectPrefixCls: 'rc-select',
  prefixCls: 'rc-pagination',
  selectComponentClass: null,
  showQuickJumper: false,
  showSizeChanger: false,
  showLessItems: false,
  showTitle: true,
  onShowSizeChange: noop,
  locale: _zh_CN2["default"],
  style: {}
};

exports["default"] = Pagination;
module.exports = exports['default'];