/**
 * Removed:
 *  - getCalendarContainer: use `getPopupContainer` instead
 *  - onOk
 *
 * New Feature:
 *  - picker
 *  - allowEmpty
 *  - selectable
 *
 * Tips: Should add faq about `datetime` mode with `defaultValue`
 */
import * as React from 'react';
import { AlignType } from 'rc-trigger/lib/interface';
import { PickerPanelBaseProps, PickerPanelDateProps, PickerPanelTimeProps } from './PickerPanel';
export interface PickerSharedProps<DateType> {
    dropdownClassName?: string;
    dropdownAlign?: AlignType;
    popupStyle?: React.CSSProperties;
    transitionName?: string;
    placeholder?: string;
    allowClear?: boolean;
    autoFocus?: boolean;
    disabled?: boolean;
    open?: boolean;
    /** Make input readOnly to avoid popup keyboard in mobile */
    inputReadOnly?: boolean;
    format?: string | string[];
    suffixIcon?: React.ReactNode;
    clearIcon?: React.ReactNode;
    prevIcon?: React.ReactNode;
    nextIcon?: React.ReactNode;
    superPrevIcon?: React.ReactNode;
    superNextIcon?: React.ReactNode;
    getPopupContainer?: (node: HTMLElement) => HTMLElement;
    onChange?: (value: DateType | null, dateString: string) => void;
    onOpenChange?: (open: boolean) => void;
    onFocus?: React.FocusEventHandler<HTMLInputElement>;
    onBlur?: React.FocusEventHandler<HTMLInputElement>;
    /** @private Internal usage, do not use in production mode!!! */
    inputRef?: React.Ref<HTMLInputElement>;
}
export interface PickerBaseProps<DateType> extends PickerSharedProps<DateType>, Omit<PickerPanelBaseProps<DateType>, 'onChange'> {
}
export interface PickerDateProps<DateType> extends PickerSharedProps<DateType>, Omit<PickerPanelDateProps<DateType>, 'onChange'> {
}
export interface PickerTimeProps<DateType> extends PickerSharedProps<DateType>, Omit<PickerPanelTimeProps<DateType>, 'onChange' | 'format'> {
}
export declare type PickerProps<DateType> = PickerBaseProps<DateType> | PickerDateProps<DateType> | PickerTimeProps<DateType>;
declare class Picker<DateType> extends React.Component<PickerProps<DateType>> {
    inputRef: React.RefObject<HTMLInputElement>;
    focus: () => void;
    blur: () => void;
    render(): JSX.Element;
}
export default Picker;
