"use strict";
/**
 * Removed:
 *  - getCalendarContainer: use `getPopupContainer` instead
 *  - onOk
 *
 * New Feature:
 *  - picker
 *  - allowEmpty
 *  - selectable
 *
 * Tips: Should add faq about `datetime` mode with `defaultValue`
 */

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) { return; } var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

var __importStar = this && this.__importStar || function (mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k in mod) {
    if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
  }
  result["default"] = mod;
  return result;
};

var __importDefault = this && this.__importDefault || function (mod) {
  return mod && mod.__esModule ? mod : {
    "default": mod
  };
};

Object.defineProperty(exports, "__esModule", {
  value: true
});

var React = __importStar(require("react"));

var KeyCode_1 = __importDefault(require("rc-util/lib/KeyCode"));

var classnames_1 = __importDefault(require("classnames"));

var PickerPanel_1 = __importDefault(require("./PickerPanel"));

var PickerTrigger_1 = __importDefault(require("./PickerTrigger"));

var dateUtil_1 = require("./utils/dateUtil");

var miscUtil_1 = require("./utils/miscUtil");

var PanelContext_1 = __importDefault(require("./PanelContext"));

var uiUtil_1 = require("./utils/uiUtil");

function InnerPicker(props) {
  var _classnames_1$default2;

  var _props$prefixCls = props.prefixCls,
      prefixCls = _props$prefixCls === void 0 ? 'rc-picker' : _props$prefixCls,
      style = props.style,
      className = props.className,
      dropdownClassName = props.dropdownClassName,
      dropdownAlign = props.dropdownAlign,
      popupStyle = props.popupStyle,
      transitionName = props.transitionName,
      generateConfig = props.generateConfig,
      locale = props.locale,
      inputReadOnly = props.inputReadOnly,
      allowClear = props.allowClear,
      autoFocus = props.autoFocus,
      showTime = props.showTime,
      picker = props.picker,
      format = props.format,
      use12Hours = props.use12Hours,
      value = props.value,
      defaultValue = props.defaultValue,
      open = props.open,
      suffixIcon = props.suffixIcon,
      clearIcon = props.clearIcon,
      disabled = props.disabled,
      placeholder = props.placeholder,
      getPopupContainer = props.getPopupContainer,
      inputRef = props.inputRef,
      onChange = props.onChange,
      onOpenChange = props.onOpenChange,
      onFocus = props.onFocus,
      onBlur = props.onBlur; // ============================= State =============================

  var formatList = miscUtil_1.toArray(uiUtil_1.getDefaultFormat(format, picker, showTime, use12Hours)); // Real value

  var _React$useState = React.useState(function () {
    if (value !== undefined) {
      return value;
    }

    if (defaultValue !== undefined) {
      return defaultValue;
    }

    return null;
  }),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      innerValue = _React$useState2[0],
      setInnerValue = _React$useState2[1];

  var mergedValue = value !== undefined ? value : innerValue; // Selected value

  var _React$useState3 = React.useState(mergedValue),
      _React$useState4 = _slicedToArray(_React$useState3, 2),
      selectedValue = _React$useState4[0],
      setInternalSelectedValue = _React$useState4[1]; // Text


  var _React$useState5 = React.useState(selectedValue ? generateConfig.locale.format(locale.locale, selectedValue, formatList[0]) : ''),
      _React$useState6 = _slicedToArray(_React$useState5, 2),
      textValue = _React$useState6[0],
      setTextValue = _React$useState6[1];

  var _React$useState7 = React.useState(false),
      _React$useState8 = _slicedToArray(_React$useState7, 2),
      typing = _React$useState8[0],
      setTyping = _React$useState8[1];
  /** Similar as `setTextValue` but accept `DateType` and convert into string */


  var setDateText = function setDateText(date) {
    setTextValue(date === null ? '' : generateConfig.locale.format(locale.locale, date, formatList[0]));
  }; // Operation ref


  var operationRef = React.useRef(null); // Trigger

  var _React$useState9 = React.useState(false),
      _React$useState10 = _slicedToArray(_React$useState9, 2),
      innerOpen = _React$useState10[0],
      setInnerOpen = _React$useState10[1];

  var mergedOpen;

  if (disabled) {
    mergedOpen = false;
  } else {
    mergedOpen = typeof open === 'boolean' ? open : innerOpen;
  }

  var triggerOpen = function triggerOpen(newOpen) {
    if (mergedOpen !== newOpen) {
      setInnerOpen(newOpen);

      if (onOpenChange) {
        onOpenChange(newOpen);
      }

      if (!newOpen && operationRef.current && operationRef.current.onClose) {
        operationRef.current.onClose();
      }
    }
  }; // Focus


  var _React$useState11 = React.useState(false),
      _React$useState12 = _slicedToArray(_React$useState11, 2),
      focused = _React$useState12[0],
      setFocused = _React$useState12[1]; // ============================= Value =============================


  var isSameTextDate = function isSameTextDate(text, date) {
    if (date === null) {
      return !text;
    }

    var inputDate = generateConfig.locale.parse(locale.locale, text, formatList);
    return dateUtil_1.isEqual(generateConfig, inputDate, date);
  }; // =========================== Formatter ===========================


  var setSelectedValue = function setSelectedValue(newDate) {
    if (!isSameTextDate(textValue, newDate)) {
      setDateText(newDate);
    }

    setInternalSelectedValue(newDate);
  };

  var onInputMouseDown = function onInputMouseDown() {
    triggerOpen(true);
    setTyping(true);
  };

  var onInputChange = function onInputChange(e) {
    var text = e.target.value;
    setTextValue(text);
    var inputDate = generateConfig.locale.parse(locale.locale, text, formatList);

    if (inputDate) {
      setSelectedValue(inputDate);
    }
  }; // ============================ Trigger ============================


  var triggerChange = function triggerChange(newValue) {
    setSelectedValue(newValue);
    setInnerValue(newValue);

    if (onChange && !dateUtil_1.isEqual(generateConfig, mergedValue, newValue)) {
      onChange(newValue, newValue ? generateConfig.locale.format(locale.locale, newValue, formatList[0]) : '');
    }
  };

  var forwardKeyDown = function forwardKeyDown(e) {
    if (!typing && mergedOpen && operationRef.current && operationRef.current.onKeyDown) {
      // Let popup panel handle keyboard
      return operationRef.current.onKeyDown(e);
    }

    return false;
  };

  var onInputKeyDown = function onInputKeyDown(e) {
    switch (e.which) {
      case KeyCode_1.default.ENTER:
        {
          if (!mergedOpen) {
            triggerOpen(true);
          } else {
            triggerChange(selectedValue);
            triggerOpen(false);
            setTyping(true);
          }

          return;
        }

      case KeyCode_1.default.TAB:
        {
          if (typing && mergedOpen && !e.shiftKey) {
            setTyping(false);
            e.preventDefault();
          } else if (!typing && mergedOpen) {
            if (!forwardKeyDown(e) && e.shiftKey) {
              setTyping(true);
              e.preventDefault();
            }
          }

          return;
        }

      case KeyCode_1.default.ESC:
        {
          triggerChange(mergedValue);
          setSelectedValue(mergedValue);
          triggerOpen(false);
          setTyping(true);
          return;
        }
    }

    if (!mergedOpen && ![KeyCode_1.default.SHIFT].includes(e.which)) {
      triggerOpen(true);
    } else {
      // Let popup panel handle keyboard
      forwardKeyDown(e);
    }
  };

  var onInputFocus = function onInputFocus(e) {
    setTyping(true);
    setFocused(true);

    if (onFocus) {
      onFocus(e);
    }
  };

  var onInputBlur = function onInputBlur(e) {
    triggerOpen(false);
    setInnerValue(selectedValue);
    triggerChange(selectedValue);
    setFocused(false);

    if (onBlur) {
      onBlur(e);
    }
  }; // ============================= Sync ==============================
  // Close should sync back with text value


  React.useEffect(function () {
    if (!mergedOpen && !isSameTextDate(textValue, mergedValue)) {
      setDateText(mergedValue);
    }
  }, [mergedOpen]); // Sync innerValue with control mode

  React.useEffect(function () {
    if (!dateUtil_1.isEqual(generateConfig, mergedValue, innerValue)) {
      // Sync inner & select value
      setInnerValue(mergedValue);
      setSelectedValue(mergedValue);
    } // Sync text


    if (!isSameTextDate(textValue, mergedValue)) {
      setDateText(mergedValue);
    }
  }, [mergedValue]); // ============================= Panel =============================

  var panelProps = _objectSpread({}, props, {
    className: undefined,
    style: undefined
  });

  var panel = React.createElement(PickerPanel_1.default, Object.assign({}, panelProps, {
    generateConfig: generateConfig,
    className: classnames_1.default(_defineProperty({}, "".concat(prefixCls, "-panel-focused"), !typing)),
    value: selectedValue,
    locale: locale,
    tabIndex: -1,
    onMouseDown: function onMouseDown(e) {
      e.preventDefault();
    },
    onChange: setSelectedValue
  }));
  var suffixNode;

  if (suffixIcon) {
    suffixNode = React.createElement("span", {
      className: "".concat(prefixCls, "-suffix")
    }, suffixIcon);
  }

  var clearNode;

  if (allowClear && mergedValue && !disabled) {
    clearNode = React.createElement("span", {
      onClick: function onClick(e) {
        e.stopPropagation();
        triggerChange(null);
      },
      className: "".concat(prefixCls, "-clear")
    }, clearIcon || React.createElement("span", {
      className: "".concat(prefixCls, "-clear-btn")
    }));
  }

  return React.createElement(PanelContext_1.default.Provider, {
    value: {
      operationRef: operationRef,
      hideHeader: picker === 'time'
    }
  }, React.createElement("div", {
    className: classnames_1.default(prefixCls, className, (_classnames_1$default2 = {}, _defineProperty(_classnames_1$default2, "".concat(prefixCls, "-disabled"), disabled), _defineProperty(_classnames_1$default2, "".concat(prefixCls, "-focused"), focused), _classnames_1$default2)),
    style: style
  }, React.createElement(PickerTrigger_1.default, {
    visible: mergedOpen,
    popupElement: panel,
    popupStyle: popupStyle,
    prefixCls: prefixCls,
    dropdownClassName: dropdownClassName,
    dropdownAlign: dropdownAlign,
    getPopupContainer: getPopupContainer,
    transitionName: transitionName
  }, React.createElement("div", {
    className: "".concat(prefixCls, "-input")
  }, React.createElement("input", {
    disabled: disabled,
    readOnly: inputReadOnly || !typing,
    onMouseDown: onInputMouseDown,
    onFocus: onInputFocus,
    onBlur: onInputBlur,
    value: textValue,
    onChange: onInputChange,
    onKeyDown: onInputKeyDown,
    autoFocus: autoFocus,
    placeholder: placeholder,
    ref: inputRef,
    size: uiUtil_1.getInputSize(picker, formatList[0])
  }), suffixNode, clearNode))));
} // Wrap with class component to enable pass generic with instance method


var Picker =
/*#__PURE__*/
function (_React$Component) {
  _inherits(Picker, _React$Component);

  function Picker() {
    var _this;

    _classCallCheck(this, Picker);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Picker).apply(this, arguments));
    _this.inputRef = React.createRef();

    _this.focus = function () {
      if (_this.inputRef.current) {
        _this.inputRef.current.focus();
      }
    };

    _this.blur = function () {
      if (_this.inputRef.current) {
        _this.inputRef.current.blur();
      }
    };

    return _this;
  }

  _createClass(Picker, [{
    key: "render",
    value: function render() {
      return React.createElement(InnerPicker, Object.assign({}, this.props, {
        inputRef: this.inputRef
      }));
    }
  }]);

  return Picker;
}(React.Component);

exports.default = Picker;