import * as React from 'react';
import { SharedTimeProps } from './panels/TimePanel';
import { GenerateConfig } from './generate';
import { Locale, PanelMode, PickerMode, DisabledTime } from './interface';
import { DateRender } from './panels/DatePanel/DateBody';
import { MonthCellRender } from './panels/MonthPanel/MonthBody';
export interface PickerPanelSharedProps<DateType> {
    prefixCls?: string;
    className?: string;
    style?: React.CSSProperties;
    /** @deprecated Will be removed in next big version. Please use `mode` instead */
    mode?: PanelMode;
    tabIndex?: number;
    locale: Locale;
    generateConfig: GenerateConfig<DateType>;
    value?: DateType | null;
    defaultValue?: DateType;
    /** [Legacy] Set default display picker view date */
    defaultPickerValue?: DateType;
    disabledDate?: (date: DateType) => boolean;
    dateRender?: DateRender<DateType>;
    monthCellRender?: MonthCellRender<DateType>;
    renderExtraFooter?: (mode: PanelMode) => React.ReactNode;
    onSelect?: (value: DateType) => void;
    onChange?: (value: DateType) => void;
    onPanelChange?: (value: DateType, mode: PanelMode) => void;
    onMouseDown?: React.MouseEventHandler<HTMLDivElement>;
}
export interface PickerPanelBaseProps<DateType> extends PickerPanelSharedProps<DateType> {
    picker: Exclude<PickerMode, 'date' | 'time'>;
}
export interface PickerPanelDateProps<DateType> extends PickerPanelSharedProps<DateType> {
    picker?: 'date';
    showToday?: boolean;
    showTime?: boolean | SharedTimeProps<DateType>;
    disabledTime?: DisabledTime<DateType>;
}
export interface PickerPanelTimeProps<DateType> extends PickerPanelSharedProps<DateType>, SharedTimeProps<DateType> {
    picker: 'time';
}
export declare type PickerPanelProps<DateType> = PickerPanelBaseProps<DateType> | PickerPanelDateProps<DateType> | PickerPanelTimeProps<DateType>;
declare function PickerPanel<DateType>(props: PickerPanelProps<DateType>): JSX.Element;
export default PickerPanel;
