import * as React from 'react';
import Picker, { PickerBaseProps, PickerDateProps, PickerTimeProps } from './Picker';
import { DisabledTimes } from './interface';
declare type RangeValue<DateType> = [DateType | null, DateType | null] | null;
export interface RangePickerSharedProps<DateType> {
    value?: RangeValue<DateType>;
    defaultValue?: RangeValue<DateType>;
    defaultPickerValue?: [DateType, DateType];
    placeholder?: [string, string];
    disabledTime?: (date: DateType | null, type: 'start' | 'end') => DisabledTimes;
    ranges?: Record<string, Exclude<RangeValue<DateType>, null> | (() => Exclude<RangeValue<DateType>, null>)>;
    separator?: React.ReactNode;
    allowEmpty?: [boolean, boolean];
    selectable?: [boolean, boolean];
    onChange?: (value: RangeValue<DateType>, formatString: [string, string]) => void;
    onCalendarChange?: (value: RangeValue<DateType>, formatString: [string, string]) => void;
    onFocus?: React.FocusEventHandler<HTMLInputElement>;
    onBlur?: React.FocusEventHandler<HTMLInputElement>;
}
declare type OmitPickerProps<Props> = Omit<Props, 'value' | 'defaultValue' | 'defaultPickerValue' | 'onChange' | 'onSelect' | 'placeholder' | 'disabledTime' | 'showToday'>;
export interface RangePickerBaseProps<DateType> extends RangePickerSharedProps<DateType>, OmitPickerProps<PickerBaseProps<DateType>> {
}
export interface RangePickerDateProps<DateType> extends RangePickerSharedProps<DateType>, OmitPickerProps<PickerDateProps<DateType>> {
}
export interface RangePickerTimeProps<DateType> extends RangePickerSharedProps<DateType>, OmitPickerProps<PickerTimeProps<DateType>> {
}
export declare type RangePickerProps<DateType> = RangePickerBaseProps<DateType> | RangePickerDateProps<DateType> | RangePickerTimeProps<DateType>;
declare class RangePicker<DateType> extends React.Component<RangePickerProps<DateType>> {
    pickerRef: React.RefObject<Picker<DateType>>;
    focus: () => void;
    blur: () => void;
    render(): JSX.Element;
}
export default RangePicker;
