"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) { return; } var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

var __importStar = this && this.__importStar || function (mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k in mod) {
    if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
  }
  result["default"] = mod;
  return result;
};

var __importDefault = this && this.__importDefault || function (mod) {
  return mod && mod.__esModule ? mod : {
    "default": mod
  };
};

Object.defineProperty(exports, "__esModule", {
  value: true
});

var React = __importStar(require("react"));

var classnames_1 = __importDefault(require("classnames"));

var Picker_1 = __importDefault(require("./Picker"));

var miscUtil_1 = require("./utils/miscUtil");

var RangeContext_1 = __importDefault(require("./RangeContext"));

var dateUtil_1 = require("./utils/dateUtil");

var uiUtil_1 = require("./utils/uiUtil");

function canTriggerChange(dates, allowEmpty) {
  var passStart = dates[0] || allowEmpty && allowEmpty[0];
  var passEnd = dates[1] || allowEmpty && allowEmpty[1];
  return !!(passStart && passEnd);
}

function InternalRangePicker(props) {
  var _props$prefixCls = props.prefixCls,
      prefixCls = _props$prefixCls === void 0 ? 'rc-picker' : _props$prefixCls,
      className = props.className,
      style = props.style,
      value = props.value,
      defaultValue = props.defaultValue,
      defaultPickerValue = props.defaultPickerValue,
      _props$separator = props.separator,
      separator = _props$separator === void 0 ? '~' : _props$separator,
      picker = props.picker,
      pickerRef = props.pickerRef,
      locale = props.locale,
      generateConfig = props.generateConfig,
      placeholder = props.placeholder,
      showTime = props.showTime,
      use12Hours = props.use12Hours,
      disabledTime = props.disabledTime,
      ranges = props.ranges,
      format = props.format,
      allowEmpty = props.allowEmpty,
      selectable = props.selectable,
      disabled = props.disabled,
      onChange = props.onChange,
      onCalendarChange = props.onCalendarChange,
      onFocus = props.onFocus,
      onBlur = props.onBlur;
  var formatList = miscUtil_1.toArray(uiUtil_1.getDefaultFormat(format, picker, showTime, use12Hours));
  var mergedSelectable = React.useMemo(function () {
    return [selectable && selectable[0], selectable && selectable[1]];
  }, [selectable]); // ============================= Values =============================

  var _React$useState = React.useState(function () {
    if (value !== undefined) {
      return value;
    }

    if (defaultValue !== undefined) {
      return defaultValue;
    }

    return null;
  }),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      innerValue = _React$useState2[0],
      setInnerValue = _React$useState2[1];

  var mergedValue = value !== undefined ? value : innerValue; // Get picker value, should order this internally

  var _React$useMemo = React.useMemo(function () {
    var val1 = mergedValue ? mergedValue[0] : null;
    var val2 = mergedValue ? mergedValue[1] : null; // Exchange

    if (val1 && val2 && generateConfig.isAfter(val1, val2)) {
      var tmp = val1;
      val1 = val2;
      val2 = tmp;
    }

    return [val1, val2];
  }, [mergedValue]),
      _React$useMemo2 = _slicedToArray(_React$useMemo, 2),
      value1 = _React$useMemo2[0],
      value2 = _React$useMemo2[1]; // Select value: used for click to update ranged value. Must set in pair


  var _React$useState3 = React.useState(undefined),
      _React$useState4 = _slicedToArray(_React$useState3, 2),
      selectedValues = _React$useState4[0],
      setSelectedValues = _React$useState4[1];

  React.useEffect(function () {
    setSelectedValues([value1, value2]);
  }, [value1, value2]);

  var onStartSelect = function onStartSelect(date) {
    setSelectedValues([date, value2]);
  };

  var onEndSelect = function onEndSelect(date) {
    setSelectedValues([value1, date]);
  }; // ============================= Change =============================


  var formatDate = function formatDate(date) {
    if (date) {
      return generateConfig.locale.format(locale.locale, date, formatList[0]);
    }

    return '';
  };

  var onInternalChange = function onInternalChange(values, changedByStartTime) {
    var startDate = values[0] || null;
    var endDate = values[1] || null; // If user change start time is after end time, should reset end time to null

    if (startDate && endDate && !dateUtil_1.isSameDate(generateConfig, startDate, endDate) && generateConfig.isAfter(startDate, endDate) && changedByStartTime) {
      endDate = null;
    }

    setInnerValue([startDate, endDate]);
    var startStr = formatDate(startDate);
    var endStr = formatDate(endDate);

    if (onChange && canTriggerChange([startDate, endDate], allowEmpty)) {
      onChange([startDate, endDate], [startStr, endStr]);
    }

    if (onCalendarChange) {
      onCalendarChange([startDate, endDate], [startStr, endStr]);
    }
  }; // ============================= Render =============================


  var pickerProps = _objectSpread({}, props, {
    defaultValue: undefined,
    defaultPickerValue: undefined,
    className: undefined,
    style: undefined,
    placeholder: undefined,
    disabledTime: undefined
  }); // Time


  var disabledStartTime;
  var disabledEndTime;

  if (disabledTime) {
    disabledStartTime = function disabledStartTime(date) {
      return disabledTime(date, 'start');
    };

    disabledEndTime = function disabledEndTime(date) {
      return disabledTime(date, 'end');
    };
  } // Ranges


  var extraFooterSelections;

  if (ranges) {
    extraFooterSelections = Object.keys(ranges).map(function (label) {
      return {
        label: label,
        onClick: function onClick() {
          var rangedValue = ranges[label];
          onInternalChange(typeof rangedValue === 'function' ? rangedValue() : rangedValue, false);
        }
      };
    });
  } // End date should disabled before start date


  var disabledDate = pickerProps.disabledDate;

  var disabledStartDate = function disabledStartDate(date) {
    var mergedDisabled = disabledDate ? disabledDate(date) : false;

    if (mergedSelectable[1] === false && value2) {
      mergedDisabled = !dateUtil_1.isSameDate(generateConfig, date, value2) && generateConfig.isAfter(date, value2);
    }

    return mergedDisabled;
  };

  var disabledEndDate = function disabledEndDate(date) {
    var mergedDisabled = disabledDate ? disabledDate(date) : false;

    if (!mergedDisabled && value1) {
      // Can be the same date
      mergedDisabled = !dateUtil_1.isSameDate(generateConfig, value1, date) && generateConfig.isAfter(value1, date);
    }

    return mergedDisabled;
  };

  return React.createElement(RangeContext_1.default.Provider, {
    value: {
      extraFooterSelections: extraFooterSelections,
      rangedValue: selectedValues
    }
  }, React.createElement("div", {
    className: classnames_1.default("".concat(prefixCls, "-range"), className),
    style: style
  }, React.createElement(Picker_1.default, Object.assign({}, pickerProps, {
    ref: pickerRef,
    prefixCls: prefixCls,
    value: value1,
    placeholder: placeholder && placeholder[0],
    defaultPickerValue: defaultPickerValue && defaultPickerValue[0]
  }, {
    disabledTime: disabledStartTime
  }, {
    disabled: disabled || mergedSelectable[0] === false,
    disabledDate: disabledStartDate,
    onChange: function onChange(date) {
      onInternalChange([date, value2], true);
    },
    onSelect: onStartSelect,
    onFocus: onFocus,
    onBlur: onBlur
  })), separator, React.createElement(Picker_1.default, Object.assign({}, pickerProps, {
    prefixCls: prefixCls,
    value: value2,
    placeholder: placeholder && placeholder[1],
    defaultPickerValue: defaultPickerValue && defaultPickerValue[1]
  }, {
    disabledTime: disabledEndTime
  }, {
    disabled: disabled || mergedSelectable[1] === false,
    disabledDate: disabledEndDate,
    onChange: function onChange(date) {
      onInternalChange([value1, date], false);
    },
    onSelect: onEndSelect,
    onFocus: onFocus,
    onBlur: onBlur
  }))));
} // Wrap with class component to enable pass generic with instance method


var RangePicker =
/*#__PURE__*/
function (_React$Component) {
  _inherits(RangePicker, _React$Component);

  function RangePicker() {
    var _this;

    _classCallCheck(this, RangePicker);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(RangePicker).apply(this, arguments));
    _this.pickerRef = React.createRef();

    _this.focus = function () {
      if (_this.pickerRef.current) {
        _this.pickerRef.current.focus();
      }
    };

    _this.blur = function () {
      if (_this.pickerRef.current) {
        _this.pickerRef.current.blur();
      }
    };

    return _this;
  }

  _createClass(RangePicker, [{
    key: "render",
    value: function render() {
      return React.createElement(InternalRangePicker, Object.assign({}, this.props, {
        pickerRef: this.pickerRef
      }));
    }
  }]);

  return RangePicker;
}(React.Component);

exports.default = RangePicker;