"use strict";

var __importDefault = this && this.__importDefault || function (mod) {
  return mod && mod.__esModule ? mod : {
    "default": mod
  };
};

Object.defineProperty(exports, "__esModule", {
  value: true
});

var moment_1 = __importDefault(require("moment"));

var warning_1 = require("rc-util/lib/warning");

var generateConfig = {
  // get
  getNow: function getNow() {
    return moment_1.default();
  },
  getWeekDay: function getWeekDay(date) {
    return date.weekday();
  },
  getYear: function getYear(date) {
    return date.year();
  },
  getMonth: function getMonth(date) {
    return date.month();
  },
  getDate: function getDate(date) {
    return date.date();
  },
  getHour: function getHour(date) {
    return date.hour();
  },
  getMinute: function getMinute(date) {
    return date.minute();
  },
  getSecond: function getSecond(date) {
    return date.second();
  },
  // set
  addYear: function addYear(date, diff) {
    var clone = date.clone();
    clone.add(diff, 'year');
    return clone;
  },
  addMonth: function addMonth(date, diff) {
    var clone = date.clone();
    clone.add(diff, 'month');
    return clone;
  },
  addDate: function addDate(date, diff) {
    var clone = date.clone();
    clone.add(diff, 'day');
    return clone;
  },
  setYear: function setYear(date, year) {
    var clone = date.clone();
    clone.year(year);
    return clone;
  },
  setMonth: function setMonth(date, month) {
    var clone = date.clone();
    clone.month(month);
    return clone;
  },
  setDate: function setDate(date, num) {
    var clone = date.clone();
    clone.date(num);
    return clone;
  },
  setHour: function setHour(date, hour) {
    var clone = date.clone();
    clone.hour(hour);
    return clone;
  },
  setMinute: function setMinute(date, minute) {
    var clone = date.clone();
    clone.minute(minute);
    return clone;
  },
  setSecond: function setSecond(date, second) {
    var clone = date.clone();
    clone.second(second);
    return clone;
  },
  // Compare
  isAfter: function isAfter(date1, date2) {
    return date1.isAfter(date2);
  },
  locale: {
    getWeekFirstDay: function getWeekFirstDay(locale) {
      var date = moment_1.default().locale(locale);
      return date.localeData().firstDayOfWeek();
    },
    getWeek: function getWeek(locale, date) {
      var clone = date.clone();
      clone.locale(locale);
      return clone.week();
    },
    getShortWeekDays: function getShortWeekDays(locale) {
      var date = moment_1.default().locale(locale);
      return date.localeData().weekdaysMin();
    },
    getShortMonths: function getShortMonths(locale) {
      var date = moment_1.default().locale(locale);
      return date.localeData().monthsShort();
    },
    format: function format(locale, date, _format) {
      var clone = date.clone();
      clone.locale(locale);
      return clone.format(_format);
    },
    parse: function parse(locale, text, formats) {
      var fallbackFormatList = [];

      for (var i = 0; i < formats.length; i += 1) {
        var format = formats[i];
        var formatText = text;

        if (format.includes('o')) {
          var matchFormat = format.match(/[YyMmDdHhSsWw]+/g);
          var matchText = formatText.match(/\d+/g);

          if (matchFormat && matchText) {
            format = matchFormat.join('');
            formatText = matchText.join('');
          } else {
            fallbackFormatList.push(format.replace(/o/g, ''));
          }
        }

        var date = moment_1.default(formatText, format, locale, true);

        if (date.isValid()) {
          return date;
        }
      } // Fallback to fuzzy matching, this should always not reach match or need fire a issue


      for (var _i = 0; _i < fallbackFormatList.length; _i += 1) {
        var _date = moment_1.default(text, fallbackFormatList[_i], locale, false);
        /* istanbul ignore next */


        if (_date.isValid()) {
          warning_1.noteOnce(false, 'Not match any format strictly and fallback to fuzzy match. Please help to fire a issue about this.');
          return _date;
        }
      }

      return null;
    }
  }
};
exports.default = generateConfig;