"use strict";

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var __importStar = this && this.__importStar || function (mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k in mod) {
    if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
  }
  result["default"] = mod;
  return result;
};

var __importDefault = this && this.__importDefault || function (mod) {
  return mod && mod.__esModule ? mod : {
    "default": mod
  };
};

Object.defineProperty(exports, "__esModule", {
  value: true
});

var React = __importStar(require("react"));

var classnames_1 = __importDefault(require("classnames"));

var dateUtil_1 = require("../../utils/dateUtil");

var RangeContext_1 = __importDefault(require("../../RangeContext"));

function DateBody(_ref) {
  var prefixCls = _ref.prefixCls,
      generateConfig = _ref.generateConfig,
      prefixColumn = _ref.prefixColumn,
      rowClassName = _ref.rowClassName,
      locale = _ref.locale,
      rowCount = _ref.rowCount,
      viewDate = _ref.viewDate,
      value = _ref.value,
      disabledDate = _ref.disabledDate,
      dateRender = _ref.dateRender,
      onSelect = _ref.onSelect;

  var _React$useContext = React.useContext(RangeContext_1.default),
      rangedValue = _React$useContext.rangedValue;

  var datePrefixCls = "".concat(prefixCls, "-cell");
  var weekFirstDay = generateConfig.locale.getWeekFirstDay(locale.locale);
  var today = generateConfig.getNow(); // ============================== Header ==============================

  var headerCells = [];
  var weekDaysLocale = locale.shortWeekDays || (generateConfig.locale.getShortWeekDays ? generateConfig.locale.getShortWeekDays(locale.locale) : []);

  if (prefixColumn) {
    headerCells.push(React.createElement("th", {
      key: "empty"
    }));
  }

  for (var i = 0; i < dateUtil_1.WEEK_DAY_COUNT; i += 1) {
    headerCells.push(React.createElement("th", {
      key: i
    }, weekDaysLocale[(i + weekFirstDay) % dateUtil_1.WEEK_DAY_COUNT]));
  } // =============================== Date ===============================


  var rows = [];
  var startDate = dateUtil_1.getWeekStartDate(locale.locale, generateConfig, viewDate);

  for (var y = 0; y < rowCount; y += 1) {
    var row = [];
    var startWeekDate = generateConfig.addDate(startDate, y * dateUtil_1.WEEK_DAY_COUNT);

    if (prefixColumn) {
      row.push(prefixColumn(startWeekDate));
    }

    var _loop = function _loop(x) {
      var _classnames_1$default;

      var currentDate = generateConfig.addDate(startWeekDate, x);
      var disabled = disabledDate && disabledDate(currentDate);
      row.push(React.createElement("td", {
        key: "".concat(x, "-").concat(y),
        onClick: function onClick() {
          if (disabled) {
            return;
          }

          onSelect(currentDate);
        },
        className: classnames_1.default(datePrefixCls, (_classnames_1$default = {}, _defineProperty(_classnames_1$default, "".concat(datePrefixCls, "-disabled"), disabled), _defineProperty(_classnames_1$default, "".concat(datePrefixCls, "-in-view"), dateUtil_1.isSameMonth(generateConfig, currentDate, viewDate)), _defineProperty(_classnames_1$default, "".concat(datePrefixCls, "-in-range"), dateUtil_1.isInRange(generateConfig, rangedValue && rangedValue[0], rangedValue && rangedValue[1], currentDate)), _defineProperty(_classnames_1$default, "".concat(datePrefixCls, "-range-start"), dateUtil_1.isSameDate(generateConfig, rangedValue && rangedValue[0], currentDate)), _defineProperty(_classnames_1$default, "".concat(datePrefixCls, "-range-end"), dateUtil_1.isSameDate(generateConfig, rangedValue && rangedValue[1], currentDate)), _defineProperty(_classnames_1$default, "".concat(datePrefixCls, "-today"), dateUtil_1.isSameDate(generateConfig, today, currentDate)), _defineProperty(_classnames_1$default, "".concat(datePrefixCls, "-selected"), dateUtil_1.isSameDate(generateConfig, value, currentDate)), _classnames_1$default))
      }, dateRender ? dateRender(currentDate, today) : React.createElement("div", {
        className: "".concat(datePrefixCls, "-inner")
      }, generateConfig.getDate(currentDate))));
    };

    for (var x = 0; x < dateUtil_1.WEEK_DAY_COUNT; x += 1) {
      _loop(x);
    }

    rows.push(React.createElement("tr", {
      key: y,
      className: classnames_1.default(rowClassName && rowClassName(startWeekDate))
    }, row));
  }

  return React.createElement("div", {
    className: "".concat(prefixCls, "-body")
  }, React.createElement("table", {
    className: "".concat(prefixCls, "-content")
  }, React.createElement("thead", null, React.createElement("tr", null, headerCells)), React.createElement("tbody", null, rows)));
}

exports.default = DateBody;