"use strict";

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var __importStar = this && this.__importStar || function (mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k in mod) {
    if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
  }
  result["default"] = mod;
  return result;
};

var __importDefault = this && this.__importDefault || function (mod) {
  return mod && mod.__esModule ? mod : {
    "default": mod
  };
};

Object.defineProperty(exports, "__esModule", {
  value: true
});

var React = __importStar(require("react"));

var classnames_1 = __importDefault(require("classnames"));

var dateUtil_1 = require("../../utils/dateUtil");

exports.MONTH_COL_COUNT = 3;
var MONTH_ROW_COUNT = 4;

function MonthBody(_ref) {
  var prefixCls = _ref.prefixCls,
      locale = _ref.locale,
      value = _ref.value,
      viewDate = _ref.viewDate,
      generateConfig = _ref.generateConfig,
      disabledDate = _ref.disabledDate,
      monthCellRender = _ref.monthCellRender,
      onSelect = _ref.onSelect;
  var monthPrefixCls = "".concat(prefixCls, "-cell");
  var rows = [];
  var monthsLocale = locale.shortMonths || (generateConfig.locale.getShortMonths ? generateConfig.locale.getShortMonths(locale.locale) : []);
  var startMonth = generateConfig.setMonth(viewDate, 0);

  for (var i = 0; i < MONTH_ROW_COUNT; i += 1) {
    var row = [];

    var _loop = function _loop(j) {
      var _classnames_1$default;

      var diffMonth = i * exports.MONTH_COL_COUNT + j;
      var monthDate = generateConfig.addMonth(startMonth, diffMonth);
      var disabled = disabledDate && disabledDate(monthDate);
      row.push(React.createElement("td", {
        key: j,
        className: classnames_1.default(monthPrefixCls, (_classnames_1$default = {}, _defineProperty(_classnames_1$default, "".concat(monthPrefixCls, "-disabled"), disabled), _defineProperty(_classnames_1$default, "".concat(monthPrefixCls, "-in-view"), true), _defineProperty(_classnames_1$default, "".concat(monthPrefixCls, "-selected"), dateUtil_1.isSameMonth(generateConfig, value, monthDate)), _classnames_1$default)),
        onClick: function onClick() {
          if (disabled) {
            return;
          }

          onSelect(monthDate);
        }
      }, monthCellRender ? monthCellRender(monthDate, locale) : React.createElement("div", {
        className: "".concat(monthPrefixCls, "-inner")
      }, locale.monthFormat ? generateConfig.locale.format(locale.locale, monthDate, locale.monthFormat) : monthsLocale[diffMonth])));
    };

    for (var j = 0; j < exports.MONTH_COL_COUNT; j += 1) {
      _loop(j);
    }

    rows.push(React.createElement("tr", {
      key: i
    }, row));
  }

  return React.createElement("div", {
    className: "".concat(prefixCls, "-body")
  }, React.createElement("table", {
    className: "".concat(prefixCls, "-content")
  }, React.createElement("tbody", null, rows)));
}

exports.default = MonthBody;