"use strict";

var __importStar = this && this.__importStar || function (mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k in mod) {
    if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
  }
  result["default"] = mod;
  return result;
};

var __importDefault = this && this.__importDefault || function (mod) {
  return mod && mod.__esModule ? mod : {
    "default": mod
  };
};

Object.defineProperty(exports, "__esModule", {
  value: true
});

var React = __importStar(require("react"));

var Header_1 = __importDefault(require("../Header"));

var PanelContext_1 = __importDefault(require("../../PanelContext"));

function TimeHeader(props) {
  var _React$useContext = React.useContext(PanelContext_1.default),
      hideHeader = _React$useContext.hideHeader;

  var prefixCls = props.prefixCls,
      generateConfig = props.generateConfig,
      locale = props.locale,
      value = props.value,
      format = props.format;
  var headerPrefixCls = "".concat(prefixCls, "-header");
  return hideHeader ? null : React.createElement(Header_1.default, {
    prefixCls: headerPrefixCls
  }, value ? generateConfig.locale.format(locale.locale, value, format) : "\xA0");
}

exports.default = TimeHeader;