"use strict";

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var __importStar = this && this.__importStar || function (mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k in mod) {
    if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
  }
  result["default"] = mod;
  return result;
};

var __importDefault = this && this.__importDefault || function (mod) {
  return mod && mod.__esModule ? mod : {
    "default": mod
  };
};

Object.defineProperty(exports, "__esModule", {
  value: true
});

var React = __importStar(require("react"));

var classnames_1 = __importDefault(require("classnames"));

var uiUtil_1 = require("../../utils/uiUtil");

function TimeUnitColumn(props) {
  var prefixCls = props.prefixCls,
      units = props.units,
      onSelect = props.onSelect,
      value = props.value,
      active = props.active,
      hideDisabledOptions = props.hideDisabledOptions;
  var cellPrefixCls = "".concat(prefixCls, "-cell");
  var initRef = React.useRef(true);
  var ulRef = React.useRef(null);
  var liRefs = React.useRef(new Map()); // `useLayoutEffect` here to avoid blink by duration is 0

  React.useLayoutEffect(function () {
    var li = liRefs.current.get(value);

    if (li) {
      uiUtil_1.scrollTo(ulRef.current, li.offsetTop, initRef.current ? 0 : 120);
    }

    initRef.current = false;
  }, [value]);
  return React.createElement("ul", {
    className: classnames_1.default("".concat(prefixCls, "-column"), _defineProperty({}, "".concat(prefixCls, "-column-active"), active)),
    ref: ulRef,
    style: {
      position: 'relative'
    }
  }, units.map(function (unit) {
    var _classnames_1$default2;

    if (hideDisabledOptions && unit.disabled) {
      return null;
    }

    return React.createElement("li", {
      key: unit.value,
      ref: function ref(element) {
        liRefs.current.set(unit.value, element);
      },
      className: classnames_1.default(cellPrefixCls, (_classnames_1$default2 = {}, _defineProperty(_classnames_1$default2, "".concat(cellPrefixCls, "-disabled"), unit.disabled), _defineProperty(_classnames_1$default2, "".concat(cellPrefixCls, "-selected"), value === unit.value), _classnames_1$default2)),
      onClick: function onClick() {
        if (unit.disabled) {
          return;
        }

        onSelect(unit.value);
      }
    }, React.createElement("div", {
      className: "".concat(cellPrefixCls, "-inner")
    }, unit.label));
  }));
}

exports.default = TimeUnitColumn;