"use strict";

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var __importStar = this && this.__importStar || function (mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k in mod) {
    if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
  }
  result["default"] = mod;
  return result;
};

var __importDefault = this && this.__importDefault || function (mod) {
  return mod && mod.__esModule ? mod : {
    "default": mod
  };
};

Object.defineProperty(exports, "__esModule", {
  value: true
});

var React = __importStar(require("react"));

var classnames_1 = __importDefault(require("classnames"));

var _1 = require(".");

exports.YEAR_COL_COUNT = 3;
var YEAR_ROW_COUNT = 4;

function YearBody(_ref) {
  var prefixCls = _ref.prefixCls,
      viewDate = _ref.viewDate,
      generateConfig = _ref.generateConfig,
      disabledDate = _ref.disabledDate,
      onSelect = _ref.onSelect;
  var yearPrefixCls = "".concat(prefixCls, "-cell");
  var rows = [];
  var yearNumber = generateConfig.getYear(viewDate);

  var startYear = Math.floor(yearNumber / _1.YEAR_DECADE_COUNT) * _1.YEAR_DECADE_COUNT;

  var endYear = startYear + _1.YEAR_DECADE_COUNT - 1;
  var baseYear = generateConfig.setYear(viewDate, startYear - Math.ceil((exports.YEAR_COL_COUNT * YEAR_ROW_COUNT - _1.YEAR_DECADE_COUNT) / 2));

  for (var i = 0; i < YEAR_ROW_COUNT; i += 1) {
    var row = [];

    var _loop = function _loop(j) {
      var _classnames_1$default;

      var diffYear = i * exports.YEAR_COL_COUNT + j;
      var yearDate = generateConfig.addYear(baseYear, diffYear);
      var currentYearNumber = generateConfig.getYear(yearDate);
      var disabled = disabledDate && disabledDate(yearDate);
      row.push(React.createElement("td", {
        key: j,
        className: classnames_1.default(yearPrefixCls, (_classnames_1$default = {}, _defineProperty(_classnames_1$default, "".concat(yearPrefixCls, "-disabled"), disabled), _defineProperty(_classnames_1$default, "".concat(yearPrefixCls, "-in-view"), startYear <= currentYearNumber && currentYearNumber <= endYear), _defineProperty(_classnames_1$default, "".concat(yearPrefixCls, "-selected"), currentYearNumber === yearNumber), _classnames_1$default)),
        onClick: function onClick() {
          if (disabled) {
            return;
          }

          onSelect(yearDate);
        }
      }, React.createElement("div", {
        className: "".concat(yearPrefixCls, "-inner")
      }, currentYearNumber)));
    };

    for (var j = 0; j < exports.YEAR_COL_COUNT; j += 1) {
      _loop(j);
    }

    rows.push(React.createElement("tr", {
      key: i
    }, row));
  }

  return React.createElement("div", {
    className: "".concat(prefixCls, "-body")
  }, React.createElement("table", {
    className: "".concat(prefixCls, "-content")
  }, React.createElement("tbody", null, rows)));
}

exports.default = YearBody;