"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var warning_1 = require("rc-util/lib/warning");

exports.WEEK_DAY_COUNT = 7;

function isNullEqual(value1, value2) {
  if (!value1 && !value2) {
    return true;
  }

  if (!value1 || !value2) {
    return false;
  }

  return undefined;
}

exports.isNullEqual = isNullEqual;

function isSameMonth(generateConfig, month1, month2) {
  var equal = isNullEqual(month1, month2);

  if (typeof equal === 'boolean') {
    return equal;
  }

  return generateConfig.getYear(month1) === generateConfig.getYear(month2) && generateConfig.getMonth(month1) === generateConfig.getMonth(month2);
}

exports.isSameMonth = isSameMonth;

function isSameDate(generateConfig, date1, date2) {
  var equal = isNullEqual(date1, date2);

  if (typeof equal === 'boolean') {
    return equal;
  }

  return generateConfig.getYear(date1) === generateConfig.getYear(date2) && generateConfig.getMonth(date1) === generateConfig.getMonth(date2) && generateConfig.getDate(date1) === generateConfig.getDate(date2);
}

exports.isSameDate = isSameDate;

function isSameTime(generateConfig, time1, time2) {
  var equal = isNullEqual(time1, time2);

  if (typeof equal === 'boolean') {
    return equal;
  }

  return generateConfig.getHour(time1) === generateConfig.getHour(time2) && generateConfig.getMinute(time1) === generateConfig.getMinute(time2) && generateConfig.getSecond(time1) === generateConfig.getSecond(time2);
}

exports.isSameTime = isSameTime;

function isSameWeek(generateConfig, locale, date1, date2) {
  var equal = isNullEqual(date1, date2);

  if (typeof equal === 'boolean') {
    return equal;
  }

  return generateConfig.locale.getWeek(locale, date1) === generateConfig.locale.getWeek(locale, date2);
}

exports.isSameWeek = isSameWeek;

function isEqual(generateConfig, value1, value2) {
  return isSameDate(generateConfig, value1, value2) && isSameTime(generateConfig, value1, value2);
}

exports.isEqual = isEqual;
/** Between in date but not equal of date */

function isInRange(generateConfig, startDate, endDate, current) {
  if (!startDate || !endDate) {
    return false;
  }

  return !isSameDate(generateConfig, startDate, current) && !isSameDate(generateConfig, endDate, current) && generateConfig.isAfter(current, startDate) && generateConfig.isAfter(endDate, current);
}

exports.isInRange = isInRange;

function getWeekStartDate(locale, generateConfig, value) {
  var weekFirstDay = generateConfig.locale.getWeekFirstDay(locale);
  var monthStartDate = generateConfig.setDate(value, 1);

  for (var i = 0; i < 7; i += 1) {
    var current = generateConfig.addDate(monthStartDate, -i);

    if (generateConfig.getWeekDay(current) === weekFirstDay) {
      return current;
    }
  }
  /* istanbul ignore next */

  /* eslint-disable no-lone-blocks */


  {
    warning_1.noteOnce(false, 'Not find week start date. Please check your `generateConfig`. If using default `generateConfig`, please help to fire a issue.');
    return value;
  }
}

exports.getWeekStartDate = getWeekStartDate;