"use strict";
/* eslint-disable jsx-a11y/no-noninteractive-tabindex */

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) { return; } var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

var __importStar = void 0 && (void 0).__importStar || function (mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k in mod) {
    if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
  }
  result["default"] = mod;
  return result;
};

var __importDefault = void 0 && (void 0).__importDefault || function (mod) {
  return mod && mod.__esModule ? mod : {
    "default": mod
  };
};

Object.defineProperty(exports, "__esModule", {
  value: true
});

var React = __importStar(require("react"));

var classnames_1 = __importDefault(require("classnames"));

var KeyCode_1 = __importDefault(require("rc-util/lib/KeyCode"));

var warning_1 = __importDefault(require("rc-util/lib/warning"));

var TimePanel_1 = __importDefault(require("./panels/TimePanel"));

var DatetimePanel_1 = __importDefault(require("./panels/DatetimePanel"));

var DatePanel_1 = __importDefault(require("./panels/DatePanel"));

var WeekPanel_1 = __importDefault(require("./panels/WeekPanel"));

var MonthPanel_1 = __importDefault(require("./panels/MonthPanel"));

var YearPanel_1 = __importDefault(require("./panels/YearPanel"));

var DecadePanel_1 = __importDefault(require("./panels/DecadePanel"));

var dateUtil_1 = require("./utils/dateUtil");

var PanelContext_1 = __importDefault(require("./PanelContext"));

var uiUtil_1 = require("./utils/uiUtil");

var RangeContext_1 = __importDefault(require("./RangeContext"));

function PickerPanel(props) {
  var _props$prefixCls = props.prefixCls,
      prefixCls = _props$prefixCls === void 0 ? 'rc-picker' : _props$prefixCls,
      className = props.className,
      style = props.style,
      locale = props.locale,
      generateConfig = props.generateConfig,
      value = props.value,
      defaultValue = props.defaultValue,
      defaultPickerValue = props.defaultPickerValue,
      mode = props.mode,
      _props$picker = props.picker,
      picker = _props$picker === void 0 ? 'date' : _props$picker,
      _props$tabIndex = props.tabIndex,
      tabIndex = _props$tabIndex === void 0 ? 0 : _props$tabIndex,
      showTime = props.showTime,
      showToday = props.showToday,
      renderExtraFooter = props.renderExtraFooter,
      onSelect = props.onSelect,
      onChange = props.onChange,
      onPanelChange = props.onPanelChange,
      onMouseDown = props.onMouseDown;

  var _React$useContext = React.useContext(PanelContext_1.default),
      operationRef = _React$useContext.operationRef;

  var _React$useContext2 = React.useContext(RangeContext_1.default),
      extraFooterSelections = _React$useContext2.extraFooterSelections;

  var panelRef = React.useRef({}); // Handle init logic

  var initRef = React.useRef(true); // Inner value

  var _React$useState = React.useState(function () {
    if (value !== undefined) {
      return value;
    }

    if (defaultValue !== undefined) {
      return defaultValue;
    }

    return null;
  }),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      innerValue = _React$useState2[0],
      setInnerValue = _React$useState2[1];

  var mergedValue = value !== undefined ? value : innerValue; // View date control

  var _React$useState3 = React.useState(function () {
    return defaultPickerValue || mergedValue || generateConfig.getNow();
  }),
      _React$useState4 = _slicedToArray(_React$useState3, 2),
      viewDate = _React$useState4[0],
      setViewDate = _React$useState4[1]; // Panel control


  var getInternalNextMode = function getInternalNextMode(nextMode) {
    var getNextMode = uiUtil_1.PickerModeMap[picker];

    if (getNextMode) {
      return getNextMode(nextMode);
    }

    if (nextMode === 'date' && showTime) {
      return 'datetime';
    }

    return nextMode;
  };

  var _React$useState5 = React.useState(function () {
    if (picker === 'time') {
      return 'time';
    }

    return getInternalNextMode('date');
  }),
      _React$useState6 = _slicedToArray(_React$useState5, 2),
      innerMode = _React$useState6[0],
      setInnerMode = _React$useState6[1];

  var mergedMode = mode || innerMode;

  var onInternalPanelChange = function onInternalPanelChange(newMode, viewValue) {
    var nextMode = getInternalNextMode(newMode);
    setInnerMode(nextMode);

    if (onPanelChange && mergedMode !== nextMode) {
      onPanelChange(viewValue, nextMode);
    }
  };

  var triggerSelect = function triggerSelect(date) {
    setInnerValue(date);

    if (onSelect) {
      onSelect(date);
    }

    if (onChange && !dateUtil_1.isEqual(generateConfig, date, mergedValue)) {
      onChange(date);
    }
  }; // ========================= Interactive ==========================


  var onInternalKeyDown = function onInternalKeyDown(e) {
    if (panelRef.current && panelRef.current.onKeyDown) {
      if ([KeyCode_1.default.LEFT, KeyCode_1.default.RIGHT, KeyCode_1.default.UP, KeyCode_1.default.DOWN, KeyCode_1.default.PAGE_UP, KeyCode_1.default.PAGE_DOWN, KeyCode_1.default.ENTER].includes(e.which)) {
        e.preventDefault();
      }

      return panelRef.current.onKeyDown(e);
    }
    /* istanbul ignore next */

    /* eslint-disable no-lone-blocks */


    {
      warning_1.default(false, 'Panel not correct handle keyDown event. Please help to fire issue about this.');
      return false;
    }
    /* eslint-enable no-lone-blocks */
  };

  var onInternalBlur = function onInternalBlur(e) {
    if (panelRef.current && panelRef.current.onBlur) {
      panelRef.current.onBlur(e);
    }
  };

  if (operationRef) {
    operationRef.current = {
      onKeyDown: onInternalKeyDown,
      onClose: function onClose() {
        if (panelRef.current && panelRef.current.onClose) {
          panelRef.current.onClose();
        }
      }
    };
  } // ============================ Effect ============================


  React.useEffect(function () {
    if (value && !initRef.current) {
      setViewDate(value);
    }
  }, [value]);
  React.useEffect(function () {
    initRef.current = false;
  }, []); // ============================ Panels ============================

  var panelNode;

  var pickerProps = _objectSpread({}, props, {
    operationRef: panelRef,
    prefixCls: prefixCls,
    viewDate: viewDate,
    value: mergedValue,
    onViewDateChange: setViewDate,
    onPanelChange: onInternalPanelChange
  });

  delete pickerProps.onChange;
  delete pickerProps.onSelect;

  switch (mergedMode) {
    case 'decade':
      panelNode = React.createElement(DecadePanel_1.default, Object.assign({}, pickerProps, {
        onSelect: function onSelect(date) {
          setViewDate(date);
          triggerSelect(date);
        }
      }));
      break;

    case 'year':
      panelNode = React.createElement(YearPanel_1.default, Object.assign({}, pickerProps, {
        onSelect: function onSelect(date) {
          setViewDate(date);
          triggerSelect(date);
        }
      }));
      break;

    case 'month':
      panelNode = React.createElement(MonthPanel_1.default, Object.assign({}, pickerProps, {
        onSelect: function onSelect(date) {
          setViewDate(date);
          triggerSelect(date);
        }
      }));
      break;

    case 'week':
      panelNode = React.createElement(WeekPanel_1.default, Object.assign({}, pickerProps, {
        onSelect: function onSelect(date) {
          setViewDate(date);
          triggerSelect(date);
        }
      }));
      break;

    case 'datetime':
      panelNode = React.createElement(DatetimePanel_1.default, Object.assign({}, pickerProps, {
        onSelect: function onSelect(date) {
          setViewDate(date);
          triggerSelect(date);
        }
      }));
      break;

    case 'time':
      delete pickerProps.showTime;
      panelNode = React.createElement(TimePanel_1.default, Object.assign({}, pickerProps, _typeof(showTime) === 'object' ? showTime : null, {
        onSelect: function onSelect(date) {
          setViewDate(date);
          triggerSelect(date);
        }
      }));
      break;

    default:
      panelNode = React.createElement(DatePanel_1.default, Object.assign({}, pickerProps, {
        onSelect: function onSelect(date) {
          setViewDate(date);
          triggerSelect(date);
        }
      }));
  } // ============================ Footer ============================


  var extraFooter;

  if (renderExtraFooter) {
    extraFooter = React.createElement("div", {
      className: "".concat(prefixCls, "-footer-extra")
    }, renderExtraFooter(mergedMode));
  }

  var todayNode;

  if (showToday && mergedMode === 'date' && picker === 'date') {
    todayNode = React.createElement("a", {
      className: "".concat(prefixCls, "-today-btn"),
      onClick: function onClick() {
        triggerSelect(generateConfig.getNow());
      }
    }, locale.today);
  }

  var extraSelectionNode;

  if (extraFooterSelections && extraFooterSelections.length) {
    extraSelectionNode = React.createElement("ul", {
      className: "".concat(prefixCls, "-ranges")
    }, extraFooterSelections.map(function (_ref) {
      var label = _ref.label,
          onClick = _ref.onClick;
      return React.createElement("li", {
        key: label,
        onClick: onClick
      }, label);
    }));
  }

  return React.createElement("div", {
    tabIndex: tabIndex,
    className: classnames_1.default("".concat(prefixCls, "-panel"), className),
    style: style,
    onKeyDown: onInternalKeyDown,
    onBlur: onInternalBlur,
    onMouseDown: onMouseDown
  }, panelNode, extraFooter || todayNode || extraSelectionNode ? React.createElement("div", {
    className: "".concat(prefixCls, "-footer")
  }, extraFooter, extraSelectionNode, todayNode) : null);
}

exports.default = PickerPanel;
/* eslint-enable */