"use strict";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var __importStar = void 0 && (void 0).__importStar || function (mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k in mod) {
    if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
  }
  result["default"] = mod;
  return result;
};

var __importDefault = void 0 && (void 0).__importDefault || function (mod) {
  return mod && mod.__esModule ? mod : {
    "default": mod
  };
};

Object.defineProperty(exports, "__esModule", {
  value: true
});

var React = __importStar(require("react"));

var classnames_1 = __importDefault(require("classnames"));

var DateBody_1 = __importDefault(require("./DateBody"));

var DateHeader_1 = __importDefault(require("./DateHeader"));

var dateUtil_1 = require("../../utils/dateUtil");

var uiUtil_1 = require("../../utils/uiUtil");

var DATE_ROW_COUNT = 6;

function DatePanel(props) {
  var prefixCls = props.prefixCls,
      _props$panelName = props.panelName,
      panelName = _props$panelName === void 0 ? 'date' : _props$panelName,
      keyboardConfig = props.keyboardConfig,
      active = props.active,
      operationRef = props.operationRef,
      generateConfig = props.generateConfig,
      value = props.value,
      viewDate = props.viewDate,
      onViewDateChange = props.onViewDateChange,
      onPanelChange = props.onPanelChange,
      onSelect = props.onSelect;
  var panelPrefixCls = "".concat(prefixCls, "-").concat(panelName, "-panel"); // ======================= Keyboard =======================

  operationRef.current = {
    onKeyDown: function onKeyDown(event) {
      return uiUtil_1.createKeyDownHandler(event, _objectSpread({
        onLeftRight: function onLeftRight(diff) {
          onSelect(generateConfig.addDate(value || viewDate, diff));
        },
        onCtrlLeftRight: function onCtrlLeftRight(diff) {
          onSelect(generateConfig.addYear(value || viewDate, diff));
        },
        onUpDown: function onUpDown(diff) {
          onSelect(generateConfig.addDate(value || viewDate, diff * dateUtil_1.WEEK_DAY_COUNT));
        },
        onPageUpDown: function onPageUpDown(diff) {
          onSelect(generateConfig.addMonth(value || viewDate, diff));
        }
      }, keyboardConfig));
    }
  }; // ==================== View Operation ====================

  var onYearChange = function onYearChange(diff) {
    onViewDateChange(generateConfig.addYear(viewDate, diff));
  };

  var onMonthChange = function onMonthChange(diff) {
    onViewDateChange(generateConfig.addMonth(viewDate, diff));
  };

  return React.createElement("div", {
    className: classnames_1.default(panelPrefixCls, _defineProperty({}, "".concat(panelPrefixCls, "-active"), active))
  }, React.createElement(DateHeader_1.default, Object.assign({}, props, {
    prefixCls: panelPrefixCls,
    value: value,
    viewDate: viewDate,
    // View Operation
    onPrevYear: function onPrevYear() {
      onYearChange(-1);
    },
    onNextYear: function onNextYear() {
      onYearChange(1);
    },
    onPrevMonth: function onPrevMonth() {
      onMonthChange(-1);
    },
    onNextMonth: function onNextMonth() {
      onMonthChange(1);
    },
    onMonthClick: function onMonthClick() {
      onPanelChange('month', value || viewDate);
    },
    onYearClick: function onYearClick() {
      onPanelChange('year', value || viewDate);
    }
  })), React.createElement(DateBody_1.default, Object.assign({}, props, {
    prefixCls: panelPrefixCls,
    value: value,
    viewDate: viewDate,
    rowCount: DATE_ROW_COUNT
  })));
}

exports.default = DatePanel;