"use strict";

var __importStar = void 0 && (void 0).__importStar || function (mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k in mod) {
    if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
  }
  result["default"] = mod;
  return result;
};

var __importDefault = void 0 && (void 0).__importDefault || function (mod) {
  return mod && mod.__esModule ? mod : {
    "default": mod
  };
};

Object.defineProperty(exports, "__esModule", {
  value: true
});

var React = __importStar(require("react"));

var DecadeHeader_1 = __importDefault(require("./DecadeHeader"));

var DecadeBody_1 = __importStar(require("./DecadeBody"));

var uiUtil_1 = require("../../utils/uiUtil");

exports.DECADE_UNIT_DIFF = 10;
exports.DECADE_DISTANCE_COUNT = exports.DECADE_UNIT_DIFF * 10;

function DecadePanel(props) {
  var prefixCls = props.prefixCls,
      onViewDateChange = props.onViewDateChange,
      generateConfig = props.generateConfig,
      viewDate = props.viewDate,
      operationRef = props.operationRef,
      onSelect = props.onSelect,
      onPanelChange = props.onPanelChange;
  var panelPrefixCls = "".concat(prefixCls, "-decade-panel"); // ======================= Keyboard =======================

  operationRef.current = {
    onKeyDown: function onKeyDown(event) {
      return uiUtil_1.createKeyDownHandler(event, {
        onLeftRight: function onLeftRight(diff) {
          onSelect(generateConfig.addYear(viewDate, diff * exports.DECADE_UNIT_DIFF));
        },
        onCtrlLeftRight: function onCtrlLeftRight(diff) {
          onSelect(generateConfig.addYear(viewDate, diff * exports.DECADE_DISTANCE_COUNT));
        },
        onUpDown: function onUpDown(diff) {
          onSelect(generateConfig.addYear(viewDate, diff * exports.DECADE_UNIT_DIFF * DecadeBody_1.DECADE_COL_COUNT));
        },
        onEnter: function onEnter() {
          onPanelChange('year', viewDate);
        }
      });
    }
  }; // ==================== View Operation ====================

  var onDecadesChange = function onDecadesChange(diff) {
    onViewDateChange(generateConfig.addYear(viewDate, diff * exports.DECADE_DISTANCE_COUNT));
  };

  var onInternalSelect = function onInternalSelect(date) {
    onSelect(date);
    onPanelChange('year', date);
  };

  return React.createElement("div", {
    className: panelPrefixCls
  }, React.createElement(DecadeHeader_1.default, Object.assign({}, props, {
    prefixCls: panelPrefixCls,
    onPrevDecades: function onPrevDecades() {
      onDecadesChange(-1);
    },
    onNextDecades: function onNextDecades() {
      onDecadesChange(1);
    }
  })), React.createElement(DecadeBody_1.default, Object.assign({}, props, {
    prefixCls: panelPrefixCls,
    onSelect: onInternalSelect
  })));
}

exports.default = DecadePanel;