"use strict";

var __importStar = void 0 && (void 0).__importStar || function (mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k in mod) {
    if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
  }
  result["default"] = mod;
  return result;
};

var __importDefault = void 0 && (void 0).__importDefault || function (mod) {
  return mod && mod.__esModule ? mod : {
    "default": mod
  };
};

Object.defineProperty(exports, "__esModule", {
  value: true
});

var React = __importStar(require("react"));

var TimeUnitColumn_1 = __importDefault(require("./TimeUnitColumn"));

var miscUtil_1 = require("../../utils/miscUtil");

function generateUnits(start, end, step, disabledUnits) {
  var units = [];

  for (var i = start; i <= end; i += step) {
    units.push({
      label: miscUtil_1.leftPad(i, 2),
      value: i,
      disabled: (disabledUnits || []).includes(i)
    });
  }

  return units;
}

function TimeBody(props) {
  var generateConfig = props.generateConfig,
      prefixCls = props.prefixCls,
      operationRef = props.operationRef,
      activeColumnIndex = props.activeColumnIndex,
      value = props.value,
      showHour = props.showHour,
      showMinute = props.showMinute,
      showSecond = props.showSecond,
      use12Hours = props.use12Hours,
      _props$hourStep = props.hourStep,
      hourStep = _props$hourStep === void 0 ? 1 : _props$hourStep,
      _props$minuteStep = props.minuteStep,
      minuteStep = _props$minuteStep === void 0 ? 1 : _props$minuteStep,
      _props$secondStep = props.secondStep,
      secondStep = _props$secondStep === void 0 ? 1 : _props$secondStep,
      disabledHours = props.disabledHours,
      disabledMinutes = props.disabledMinutes,
      disabledSeconds = props.disabledSeconds,
      hideDisabledOptions = props.hideDisabledOptions,
      onSelect = props.onSelect;
  var columns = [];
  var contentPrefixCls = "".concat(prefixCls, "-content");
  var isPM;
  var hour = value ? generateConfig.getHour(value) : -1;
  var minute = value ? generateConfig.getMinute(value) : -1;
  var second = value ? generateConfig.getSecond(value) : -1;

  var setTime = function setTime(isNewPM, newHour, newMinute, newSecond) {
    var newDate = value || generateConfig.getNow();
    var mergedHour = Math.max(0, newHour);
    var mergedMinute = Math.max(0, newMinute);
    var mergedSecond = Math.max(0, newSecond);
    newDate = generateConfig.setSecond(newDate, mergedSecond);
    newDate = generateConfig.setMinute(newDate, mergedMinute);
    newDate = generateConfig.setHour(newDate, !use12Hours || !isNewPM ? mergedHour : mergedHour + 12);
    return newDate;
  }; // ========================= Unit =========================


  var hours = generateUnits(0, use12Hours ? 11 : 23, hourStep, disabledHours && disabledHours()); // Should additional logic to handle 12 hours

  if (use12Hours && hour !== -1) {
    isPM = hour >= 12;
    hour %= 12;
    hours[0].label = '12';
  }

  var minutes = generateUnits(0, 59, minuteStep, disabledMinutes && disabledMinutes(hour));
  var seconds = generateUnits(0, 59, secondStep, disabledSeconds && disabledSeconds(hour, minute)); // ====================== Operations ======================

  operationRef.current = {
    onUpDown: function onUpDown(diff) {
      var column = columns[activeColumnIndex];

      if (column) {
        var valueIndex = column.units.findIndex(function (unit) {
          return unit.value === column.value;
        });
        var unitLen = column.units.length;

        for (var i = 1; i < unitLen; i += 1) {
          var nextUnit = column.units[(valueIndex + diff * i + unitLen) % unitLen];

          if (nextUnit.disabled !== true) {
            column.onSelect(nextUnit.value);
            break;
          }
        }
      }
    }
  }; // ======================== Render ========================

  function addColumnNode(condition, node, columnValue, units, onColumnSelect) {
    if (condition !== false) {
      columns.push({
        node: React.cloneElement(node, {
          value: columnValue,
          active: activeColumnIndex === columns.length,
          onSelect: onColumnSelect,
          units: units,
          hideDisabledOptions: hideDisabledOptions
        }),
        onSelect: onColumnSelect,
        value: columnValue,
        units: units
      });
    }
  } // Hour


  addColumnNode(showHour, React.createElement(TimeUnitColumn_1.default, {
    key: "hour",
    prefixCls: prefixCls
  }), hour, hours, function (num) {
    onSelect(setTime(isPM, num, minute, second));
  }); // Minute

  addColumnNode(showMinute, React.createElement(TimeUnitColumn_1.default, {
    key: "minute",
    prefixCls: prefixCls
  }), minute, minutes, function (num) {
    onSelect(setTime(isPM, hour, num, second));
  }); // Second

  addColumnNode(showSecond, React.createElement(TimeUnitColumn_1.default, {
    key: "second",
    prefixCls: prefixCls
  }), second, seconds, function (num) {
    onSelect(setTime(isPM, hour, minute, num));
  }); // 12 Hours

  var PMIndex = -1;

  if (typeof isPM === 'boolean') {
    PMIndex = isPM ? 1 : 0;
  }

  addColumnNode(use12Hours === true, React.createElement(TimeUnitColumn_1.default, {
    key: "12hours",
    prefixCls: prefixCls
  }), PMIndex, [{
    label: 'AM',
    value: 0
  }, {
    label: 'PM',
    value: 1
  }], function (num) {
    onSelect(setTime(!!num, hour, minute, second));
  });
  return React.createElement("div", {
    className: contentPrefixCls
  }, columns.map(function (_ref) {
    var node = _ref.node;
    return node;
  }));
}

exports.default = TimeBody;