"use strict";

var __importStar = void 0 && (void 0).__importStar || function (mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k in mod) {
    if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
  }
  result["default"] = mod;
  return result;
};

var __importDefault = void 0 && (void 0).__importDefault || function (mod) {
  return mod && mod.__esModule ? mod : {
    "default": mod
  };
};

Object.defineProperty(exports, "__esModule", {
  value: true
});

var React = __importStar(require("react"));

var YearHeader_1 = __importDefault(require("./YearHeader"));

var YearBody_1 = __importStar(require("./YearBody"));

var uiUtil_1 = require("../../utils/uiUtil");

exports.YEAR_DECADE_COUNT = 10;

function YearPanel(props) {
  var prefixCls = props.prefixCls,
      operationRef = props.operationRef,
      onViewDateChange = props.onViewDateChange,
      generateConfig = props.generateConfig,
      value = props.value,
      viewDate = props.viewDate,
      _onSelect = props.onSelect,
      onPanelChange = props.onPanelChange;
  var panelPrefixCls = "".concat(prefixCls, "-year-panel"); // ======================= Keyboard =======================

  operationRef.current = {
    onKeyDown: function onKeyDown(event) {
      return uiUtil_1.createKeyDownHandler(event, {
        onLeftRight: function onLeftRight(diff) {
          _onSelect(generateConfig.addYear(value || viewDate, diff));
        },
        onCtrlLeftRight: function onCtrlLeftRight(diff) {
          _onSelect(generateConfig.addYear(value || viewDate, diff * exports.YEAR_DECADE_COUNT));
        },
        onUpDown: function onUpDown(diff) {
          _onSelect(generateConfig.addYear(value || viewDate, diff * YearBody_1.YEAR_COL_COUNT));
        },
        onEnter: function onEnter() {
          onPanelChange('month', value || viewDate);
        }
      });
    }
  }; // ==================== View Operation ====================

  var onDecadeChange = function onDecadeChange(diff) {
    onViewDateChange(generateConfig.addYear(viewDate, diff * 10));
  };

  return React.createElement("div", {
    className: panelPrefixCls
  }, React.createElement(YearHeader_1.default, Object.assign({}, props, {
    prefixCls: panelPrefixCls,
    onPrevDecade: function onPrevDecade() {
      onDecadeChange(-1);
    },
    onNextDecade: function onNextDecade() {
      onDecadeChange(1);
    },
    onDecadeClick: function onDecadeClick() {
      onPanelChange('decade', value || viewDate);
    }
  })), React.createElement(YearBody_1.default, Object.assign({}, props, {
    prefixCls: panelPrefixCls,
    onSelect: function onSelect(date) {
      onPanelChange('month', date);

      _onSelect(date);
    }
  })));
}

exports.default = YearPanel;