import { GenerateConfig } from '../generate';
import { NullableDateType } from '../interface';
export declare const WEEK_DAY_COUNT = 7;
export declare function isNullEqual<T>(value1: T, value2: T): boolean | undefined;
export declare function isSameMonth<DateType>(generateConfig: GenerateConfig<DateType>, month1: NullableDateType<DateType>, month2: NullableDateType<DateType>): boolean;
export declare function isSameDate<DateType>(generateConfig: GenerateConfig<DateType>, date1: NullableDateType<DateType>, date2: NullableDateType<DateType>): boolean;
export declare function isSameTime<DateType>(generateConfig: GenerateConfig<DateType>, time1: NullableDateType<DateType>, time2: NullableDateType<DateType>): boolean;
export declare function isSameWeek<DateType>(generateConfig: GenerateConfig<DateType>, locale: string, date1: NullableDateType<DateType>, date2: NullableDateType<DateType>): boolean;
export declare function isEqual<DateType>(generateConfig: GenerateConfig<DateType>, value1: NullableDateType<DateType>, value2: NullableDateType<DateType>): boolean;
/** Between in date but not equal of date */
export declare function isInRange<DateType>(generateConfig: GenerateConfig<DateType>, startDate: DateType, endDate: DateType, current: DateType): boolean;
export declare function getWeekStartDate<DateType>(locale: string, generateConfig: GenerateConfig<DateType>, value: DateType): DateType;
