"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = useRangeDisabled;

var React = _interopRequireWildcard(require("react"));

var _miscUtil = require("../utils/miscUtil");

var _dateUtil = require("../utils/dateUtil");

function useRangeDisabled(_ref, disabledStart, disabledEnd) {
  var picker = _ref.picker,
      locale = _ref.locale,
      selectedValue = _ref.selectedValue,
      disabledDate = _ref.disabledDate,
      disabled = _ref.disabled,
      generateConfig = _ref.generateConfig;
  var startDate = (0, _miscUtil.getValue)(selectedValue, 0);
  var endDate = (0, _miscUtil.getValue)(selectedValue, 1);

  function weekNumber(date) {
    var year = generateConfig.getYear(date);
    var week = generateConfig.locale.getWeek(locale.locale, date);
    return year * 100 + week;
  }

  function monthNumber(date) {
    var year = generateConfig.getYear(date);
    var month = generateConfig.getMonth(date);
    return year * 100 + month;
  }

  function quarterNumber(date) {
    var year = generateConfig.getYear(date);
    var quarter = (0, _dateUtil.getQuarter)(generateConfig, date);
    return year * 10 + quarter;
  }

  var disabledStartDate = React.useCallback(function (date) {
    if (disabledDate && disabledDate(date)) {
      return true;
    } // Disabled range


    if (disabled[1] && endDate) {
      return !(0, _dateUtil.isSameDate)(generateConfig, date, endDate) && generateConfig.isAfter(date, endDate);
    } // Disabled part


    if (disabledStart && endDate) {
      switch (picker) {
        case 'quarter':
          return quarterNumber(date) > quarterNumber(endDate);

        case 'month':
          return monthNumber(date) > monthNumber(endDate);

        case 'week':
          return weekNumber(date) > weekNumber(endDate);

        default:
          return !(0, _dateUtil.isSameDate)(generateConfig, date, endDate) && generateConfig.isAfter(date, endDate);
      }
    }

    return false;
  }, [disabledDate, disabled[1], endDate, disabledStart]);
  var disabledEndDate = React.useCallback(function (date) {
    if (disabledDate && disabledDate(date)) {
      return true;
    } // Disabled range


    if (disabled[0] && startDate) {
      return !(0, _dateUtil.isSameDate)(generateConfig, date, endDate) && generateConfig.isAfter(startDate, date);
    } // Disabled part


    if (disabledEnd && startDate) {
      switch (picker) {
        case 'quarter':
          return quarterNumber(date) < quarterNumber(startDate);

        case 'month':
          return monthNumber(date) < monthNumber(startDate);

        case 'week':
          return weekNumber(date) < weekNumber(startDate);

        default:
          return !(0, _dateUtil.isSameDate)(generateConfig, date, startDate) && generateConfig.isAfter(startDate, date);
      }
    }

    return false;
  }, [disabledDate, disabled[0], startDate, disabledEnd]);
  return [disabledStartDate, disabledEndDate];
}