import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/esm/objectWithoutProperties";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _typeof from "@babel/runtime/helpers/esm/typeof";
var _excluded = ["prefixCls", "direction", "options", "disabled", "defaultValue", "value", "onChange", "className", "motionName"];
import * as React from 'react';
import classNames from 'classnames';
import CSSMotion from 'rc-motion';
import useMergedState from "rc-util/es/hooks/useMergedState";
import { composeRef } from "rc-util/es/ref";
import omit from "rc-util/es/omit";

function getValidTitle(option) {
  if (typeof option.title !== 'undefined') {
    return option.title;
  } // read `label` when title is `undefined`


  if (_typeof(option.label) !== 'object') {
    var _option$label;

    return (_option$label = option.label) === null || _option$label === void 0 ? void 0 : _option$label.toString();
  }
}

function normalizeOptions(options) {
  return options.map(function (option) {
    if (_typeof(option) === 'object' && option !== null) {
      var validTitle = getValidTitle(option);
      return _objectSpread(_objectSpread({}, option), {}, {
        title: validTitle
      });
    }

    return {
      label: option === null || option === void 0 ? void 0 : option.toString(),
      title: option === null || option === void 0 ? void 0 : option.toString(),
      value: option
    };
  });
}

var calcThumbStyle = function calcThumbStyle(targetElement) {
  return {
    transform: "translateX(".concat(targetElement.offsetLeft, "px)"),
    width: targetElement.clientWidth
  };
};

var InternalSegmentedOption = function InternalSegmentedOption(_ref) {
  var prefixCls = _ref.prefixCls,
      className = _ref.className,
      disabled = _ref.disabled,
      checked = _ref.checked,
      label = _ref.label,
      title = _ref.title,
      value = _ref.value,
      onChange = _ref.onChange;

  var handleChange = function handleChange(event) {
    if (disabled) {
      return;
    }

    onChange(event, value);
  };

  return /*#__PURE__*/React.createElement("label", {
    className: classNames(className, _defineProperty({}, "".concat(prefixCls, "-item-disabled"), disabled))
  }, /*#__PURE__*/React.createElement("input", {
    className: "".concat(prefixCls, "-item-input"),
    type: "radio",
    disabled: disabled,
    checked: checked,
    onChange: handleChange
  }), /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefixCls, "-item-label"),
    title: title
  }, label));
};

var Segmented = /*#__PURE__*/React.forwardRef(function (props, ref) {
  var _segmentedOptions$, _classNames2;

  var _props$prefixCls = props.prefixCls,
      prefixCls = _props$prefixCls === void 0 ? 'rc-segmented' : _props$prefixCls,
      direction = props.direction,
      options = props.options,
      disabled = props.disabled,
      defaultValue = props.defaultValue,
      value = props.value,
      onChange = props.onChange,
      _props$className = props.className,
      className = _props$className === void 0 ? '' : _props$className,
      _props$motionName = props.motionName,
      motionName = _props$motionName === void 0 ? 'thumb-motion' : _props$motionName,
      restProps = _objectWithoutProperties(props, _excluded);

  var containerRef = React.useRef(null);
  var mergedRef = composeRef(containerRef, ref);
  var thumbMoveStatus = React.useRef({
    from: null,
    to: null
  });
  var segmentedOptions = React.useMemo(function () {
    return normalizeOptions(options);
  }, [options]);

  var _useMergedState = useMergedState((_segmentedOptions$ = segmentedOptions[0]) === null || _segmentedOptions$ === void 0 ? void 0 : _segmentedOptions$.value, {
    value: props.value,
    defaultValue: defaultValue
  }),
      _useMergedState2 = _slicedToArray(_useMergedState, 2),
      selected = _useMergedState2[0],
      setSelected = _useMergedState2[1];

  var _React$useState = React.useState(selected),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      visualSelected = _React$useState2[0],
      setVisualSelected = _React$useState2[1];

  var _React$useState3 = React.useState(false),
      _React$useState4 = _slicedToArray(_React$useState3, 2),
      thumbShow = _React$useState4[0],
      setThumbShow = _React$useState4[1];

  var doThumbAnimation = React.useCallback(function (selectedValue) {
    var _containerRef$current;

    var segmentedItemIndex = segmentedOptions.findIndex(function (n) {
      return n.value === selectedValue;
    });

    if (segmentedItemIndex < 0) {
      return;
    } // find target element


    var toElement = (_containerRef$current = containerRef.current) === null || _containerRef$current === void 0 ? void 0 : _containerRef$current.querySelector(".".concat(prefixCls, "-item:nth-child(").concat(segmentedItemIndex + 1, ")"));

    if (toElement) {
      var _containerRef$current2;

      // find source element
      var fromElement = (_containerRef$current2 = containerRef.current) === null || _containerRef$current2 === void 0 ? void 0 : _containerRef$current2.querySelector(".".concat(prefixCls, "-item-selected"));

      if (fromElement && toElement && thumbMoveStatus.current) {
        // calculate for thumb moving animation
        thumbMoveStatus.current.from = calcThumbStyle(fromElement);
        thumbMoveStatus.current.to = calcThumbStyle(toElement); // trigger css-motion starts

        setThumbShow(true);
      }
    }
  }, [prefixCls, segmentedOptions]); // get latest version of `visualSelected`

  var latestVisualSelected = React.useRef(visualSelected);
  React.useEffect(function () {
    latestVisualSelected.current = visualSelected;
  });
  React.useEffect(function () {
    // Syncing `visualSelected` when `selected` changed
    // and do thumb animation
    if ((typeof selected === 'string' || typeof selected === 'number') && selected !== latestVisualSelected.current) {
      doThumbAnimation(selected);
    }
  }, [selected]);

  var handleChange = function handleChange(event, val) {
    if (disabled) {
      return;
    }

    setSelected(val);
    onChange === null || onChange === void 0 ? void 0 : onChange(val);
  }; // --- motion event handlers for thumb move


  var handleThumbEnterStart = function handleThumbEnterStart() {
    var fromStyle = thumbMoveStatus.current.from;

    if (fromStyle) {
      setVisualSelected(undefined);
      return fromStyle;
    }
  };

  var handleThumbEnterActive = function handleThumbEnterActive() {
    var toStyle = thumbMoveStatus.current.to;

    if (toStyle) {
      return toStyle;
    }
  };

  var handleThumbEnterEnd = function handleThumbEnterEnd() {
    setThumbShow(false);
    setVisualSelected(selected);

    if (thumbMoveStatus.current) {
      thumbMoveStatus.current = {
        from: null,
        to: null
      };
    }
  };

  var divProps = omit(restProps, ['children']);
  var wrapperCls = "".concat(prefixCls, "-wrapper");
  return /*#__PURE__*/React.createElement("div", _objectSpread(_objectSpread({}, divProps), {}, {
    className: classNames(wrapperCls, (_classNames2 = {}, _defineProperty(_classNames2, "".concat(wrapperCls, "-rtl"), direction === 'rtl'), _defineProperty(_classNames2, "".concat(wrapperCls, "-disabled"), disabled), _classNames2), className),
    ref: mergedRef
  }), /*#__PURE__*/React.createElement("div", {
    className: classNames(prefixCls, _defineProperty({}, "".concat(prefixCls, "-disabled"), disabled))
  }, /*#__PURE__*/React.createElement(CSSMotion, {
    visible: thumbShow,
    motionName: "".concat(prefixCls, "-").concat(motionName),
    motionDeadline: 300,
    onEnterStart: handleThumbEnterStart,
    onEnterActive: handleThumbEnterActive,
    onEnterEnd: handleThumbEnterEnd
  }, function (_ref2) {
    var motionClassName = _ref2.className,
        motionStyle = _ref2.style;
    return /*#__PURE__*/React.createElement("div", {
      style: motionStyle,
      className: classNames("".concat(prefixCls, "-thumb"), motionClassName)
    });
  }), segmentedOptions.map(function (segmentedOption) {
    return /*#__PURE__*/React.createElement(InternalSegmentedOption, _objectSpread(_objectSpread({
      key: segmentedOption.value,
      prefixCls: prefixCls,
      className: classNames(segmentedOption.className, "".concat(prefixCls, "-item"), _defineProperty({}, "".concat(prefixCls, "-item-selected"), segmentedOption.value === visualSelected)),
      checked: segmentedOption.value === selected,
      onChange: handleChange
    }, segmentedOption), {}, {
      disabled: !!disabled || !!segmentedOption.disabled
    }));
  })));
});
Segmented.displayName = 'Segmented';
Segmented.defaultProps = {
  options: []
};
export default Segmented;