import React from 'react';
import Input from './Input';

var SingleSelector = function SingleSelector(_ref) {
  var inputElement = _ref.inputElement,
      prefixCls = _ref.prefixCls,
      id = _ref.id,
      inputRef = _ref.inputRef,
      disabled = _ref.disabled,
      autoFocus = _ref.autoFocus,
      accessibilityIndex = _ref.accessibilityIndex,
      mode = _ref.mode,
      open = _ref.open,
      values = _ref.values,
      placeholder = _ref.placeholder,
      tabIndex = _ref.tabIndex,
      showSearch = _ref.showSearch,
      searchValue = _ref.searchValue,
      activeValue = _ref.activeValue,
      onInputKeyDown = _ref.onInputKeyDown,
      onInputChange = _ref.onInputChange;
  var combobox = mode === 'combobox';
  var inputEditable = combobox || showSearch && open;
  var item = values[0];
  var inputValue = searchValue;

  if (combobox) {
    inputValue = item ? String(item.value) : activeValue || searchValue;
  }

  var hasTextInput = !!inputValue;
  return React.createElement(React.Fragment, null, React.createElement("span", {
    className: "".concat(prefixCls, "-selection-search")
  }, React.createElement(Input, {
    ref: inputRef,
    prefixCls: prefixCls,
    id: id,
    open: open,
    inputElement: inputElement,
    disabled: disabled,
    autoFocus: autoFocus,
    editable: inputEditable,
    accessibilityIndex: accessibilityIndex,
    value: inputValue,
    onKeyDown: onInputKeyDown,
    onChange: onInputChange,
    tabIndex: tabIndex
  })), !combobox && item && !hasTextInput && React.createElement("span", {
    className: "".concat(prefixCls, "-selection-item")
  }, item.label), !item && !hasTextInput && React.createElement("span", {
    className: "".concat(prefixCls, "-selection-placeholder")
  }, placeholder));
};

export default SingleSelector;