"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _Input = _interopRequireDefault(require("./Input"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var SingleSelector = function SingleSelector(_ref) {
  var inputElement = _ref.inputElement,
      prefixCls = _ref.prefixCls,
      id = _ref.id,
      inputRef = _ref.inputRef,
      disabled = _ref.disabled,
      autoFocus = _ref.autoFocus,
      accessibilityIndex = _ref.accessibilityIndex,
      mode = _ref.mode,
      open = _ref.open,
      values = _ref.values,
      placeholder = _ref.placeholder,
      tabIndex = _ref.tabIndex,
      showSearch = _ref.showSearch,
      searchValue = _ref.searchValue,
      activeValue = _ref.activeValue,
      onInputKeyDown = _ref.onInputKeyDown,
      onInputChange = _ref.onInputChange;
  var combobox = mode === 'combobox';
  var inputEditable = combobox || showSearch && open;
  var item = values[0];
  var inputValue = searchValue;

  if (combobox) {
    inputValue = item ? String(item.value) : activeValue || searchValue;
  }

  var hasTextInput = !!inputValue;
  return _react.default.createElement(_react.default.Fragment, null, _react.default.createElement("span", {
    className: "".concat(prefixCls, "-selection-search")
  }, _react.default.createElement(_Input.default, {
    ref: inputRef,
    prefixCls: prefixCls,
    id: id,
    open: open,
    inputElement: inputElement,
    disabled: disabled,
    autoFocus: autoFocus,
    editable: inputEditable,
    accessibilityIndex: accessibilityIndex,
    value: inputValue,
    onKeyDown: onInputKeyDown,
    onChange: onInputChange,
    tabIndex: tabIndex
  })), !combobox && item && !hasTextInput && _react.default.createElement("span", {
    className: "".concat(prefixCls, "-selection-item")
  }, item.label), !item && !hasTextInput && _react.default.createElement("span", {
    className: "".concat(prefixCls, "-selection-placeholder")
  }, placeholder));
};

var _default = SingleSelector;
exports.default = _default;