/**
 * Cursor rule:
 * 1. Only `showSearch` enabled
 * 2. Only `open` is `true`
 * 3. When typing, set `open` to `true` which hit rule of 2
 *
 * Accessibility:
 * - https://www.w3.org/TR/wai-aria-practices/examples/combobox/aria1.1pattern/listbox-combo.html
 */
import * as React from 'react';
import { LabelValueType, RawValueType } from '../interface/generator';
import { RenderNode, Mode } from '../interface';
export interface InnerSelectorProps {
    prefixCls: string;
    id: string;
    mode: Mode;
    inputRef: React.Ref<HTMLInputElement | HTMLTextAreaElement>;
    placeholder?: React.ReactNode;
    disabled?: boolean;
    autoFocus?: boolean;
    values: LabelValueType[];
    showSearch?: boolean;
    searchValue: string;
    accessibilityIndex: number;
    open: boolean;
    tabIndex?: number;
    onInputKeyDown: React.KeyboardEventHandler<HTMLInputElement | HTMLTextAreaElement>;
    onInputChange: React.ChangeEventHandler<HTMLInputElement | HTMLTextAreaElement>;
}
export interface RefSelectorProps {
    focus: () => void;
    blur: () => void;
}
export interface SelectorProps {
    id: string;
    prefixCls: string;
    showSearch?: boolean;
    open: boolean;
    /** Display in the Selector value, it's not same as `value` prop */
    values: LabelValueType[];
    multiple: boolean;
    mode: Mode;
    searchValue: string;
    activeValue: string;
    inputElement: JSX.Element;
    autoFocus?: boolean;
    accessibilityIndex: number;
    tabIndex?: number;
    disabled?: boolean;
    placeholder?: React.ReactNode;
    removeIcon?: RenderNode;
    maxTagCount?: number;
    maxTagTextLength?: number;
    maxTagPlaceholder?: (omittedValues: LabelValueType[]) => React.ReactNode;
    choiceTransitionName?: string;
    onToggleOpen: (open?: boolean) => void;
    /** `onSearch` returns go next step boolean to check if need do toggle open */
    onSearch: (searchValue: string) => boolean;
    onSelect: (value: RawValueType, option: {
        selected: boolean;
    }) => void;
    onInputKeyDown?: React.KeyboardEventHandler<HTMLInputElement | HTMLTextAreaElement>;
}
declare const ForwardSelector: React.ForwardRefExoticComponent<SelectorProps & React.RefAttributes<RefSelectorProps>>;
export default ForwardSelector;
