"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var React = _interopRequireWildcard(require("react"));

var _KeyCode = _interopRequireDefault(require("rc-util/lib/KeyCode"));

var _MultipleSelector = _interopRequireDefault(require("./MultipleSelector"));

var _SingleSelector = _interopRequireDefault(require("./SingleSelector"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

/**
 * Cursor rule:
 * 1. Only `showSearch` enabled
 * 2. Only `open` is `true`
 * 3. When typing, set `open` to `true` which hit rule of 2
 *
 * Accessibility:
 * - https://www.w3.org/TR/wai-aria-practices/examples/combobox/aria1.1pattern/listbox-combo.html
 */
var Selector = function Selector(props, ref) {
  var inputRef = React.useRef(null);
  var prefixCls = props.prefixCls,
      multiple = props.multiple,
      onSearch = props.onSearch,
      onToggleOpen = props.onToggleOpen,
      onInputKeyDown = props.onInputKeyDown; // ======================= Ref =======================

  React.useImperativeHandle(ref, function () {
    return {
      focus: function focus() {
        inputRef.current.focus();
      },
      blur: function blur() {
        inputRef.current.blur();
      }
    };
  }); // ====================== Input ======================

  var onInternalInputKeyDown = function onInternalInputKeyDown(event) {
    var which = event.which;

    if (which === _KeyCode.default.UP || which === _KeyCode.default.DOWN) {
      event.preventDefault();
    }

    if (onInputKeyDown) {
      onInputKeyDown(event);
    }

    if (![_KeyCode.default.SHIFT, _KeyCode.default.TAB, _KeyCode.default.BACKSPACE, _KeyCode.default.ESC].includes(which)) {
      onToggleOpen(true);
    }
  };

  var onInputChange = function onInputChange(_ref) {
    var value = _ref.target.value;

    if (onSearch(value) !== false) {
      onToggleOpen(true);
    }
  }; // ====================== Focus ======================
  // Should focus input if click the selector


  var onClick = function onClick(_ref2) {
    var target = _ref2.target;

    if (target !== inputRef.current) {
      inputRef.current.focus();
    }
  };

  var onMouseDown = function onMouseDown(event) {
    if (event.target !== inputRef.current) {
      event.preventDefault();
    }

    onToggleOpen();
  }; // ================= Inner Selector ==================


  var sharedProps = {
    inputRef: inputRef,
    onInputKeyDown: onInternalInputKeyDown,
    onInputChange: onInputChange
  };
  var selectNode = multiple ? React.createElement(_MultipleSelector.default, Object.assign({}, props, sharedProps)) : React.createElement(_SingleSelector.default, Object.assign({}, props, sharedProps));
  return React.createElement("div", {
    className: "".concat(prefixCls, "-selector"),
    onClick: onClick,
    onMouseDown: onMouseDown
  }, selectNode);
};

var ForwardSelector = React.forwardRef(Selector);
ForwardSelector.displayName = 'Selector';
var _default = ForwardSelector;
exports.default = _default;