import React from 'react';
import pickAttrs from "rc-util/es/pickAttrs";
import Input from './Input';

var SingleSelector = function SingleSelector(props) {
  var inputElement = props.inputElement,
      prefixCls = props.prefixCls,
      id = props.id,
      inputRef = props.inputRef,
      disabled = props.disabled,
      autoFocus = props.autoFocus,
      autoComplete = props.autoComplete,
      accessibilityIndex = props.accessibilityIndex,
      mode = props.mode,
      open = props.open,
      values = props.values,
      placeholder = props.placeholder,
      tabIndex = props.tabIndex,
      showSearch = props.showSearch,
      searchValue = props.searchValue,
      activeValue = props.activeValue,
      onInputKeyDown = props.onInputKeyDown,
      onInputMouseDown = props.onInputMouseDown,
      onInputChange = props.onInputChange,
      onInputPaste = props.onInputPaste;
  var combobox = mode === 'combobox';
  var inputEditable = combobox || showSearch && open;
  var item = values[0];

  var getDisplayValue = function getDisplayValue(value) {
    return value === null ? '' : String(value);
  };

  var inputValue = searchValue;

  if (combobox) {
    inputValue = item ? getDisplayValue(item.value) : activeValue || searchValue;
  } // Not show text when closed expect combobox mode


  var hasTextInput = mode !== 'combobox' && !open ? false : !!inputValue;
  return React.createElement(React.Fragment, null, React.createElement("span", {
    className: "".concat(prefixCls, "-selection-search")
  }, React.createElement(Input, {
    ref: inputRef,
    prefixCls: prefixCls,
    id: id,
    open: open,
    inputElement: inputElement,
    disabled: disabled,
    autoFocus: autoFocus,
    autoComplete: autoComplete,
    editable: inputEditable,
    accessibilityIndex: accessibilityIndex,
    value: inputValue,
    onKeyDown: onInputKeyDown,
    onMouseDown: onInputMouseDown,
    onChange: onInputChange,
    onPaste: onInputPaste,
    tabIndex: tabIndex,
    attrs: pickAttrs(props, true)
  })), !combobox && item && !hasTextInput && React.createElement("span", {
    className: "".concat(prefixCls, "-selection-item")
  }, item.label), !item && !hasTextInput && React.createElement("span", {
    className: "".concat(prefixCls, "-selection-placeholder")
  }, placeholder));
};

export default SingleSelector;