"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _pickAttrs = _interopRequireDefault(require("rc-util/lib/pickAttrs"));

var _CSSMotionList = _interopRequireDefault(require("rc-animate/lib/CSSMotionList"));

var _TransBtn = _interopRequireDefault(require("../TransBtn"));

var _Input = _interopRequireDefault(require("./Input"));

var _useLayoutEffect = _interopRequireDefault(require("../hooks/useLayoutEffect"));

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var REST_TAG_KEY = '__RC_SELECT_MAX_REST_COUNT__';

var SelectSelector = function SelectSelector(props) {
  var id = props.id,
      prefixCls = props.prefixCls,
      values = props.values,
      open = props.open,
      searchValue = props.searchValue,
      inputRef = props.inputRef,
      placeholder = props.placeholder,
      disabled = props.disabled,
      mode = props.mode,
      showSearch = props.showSearch,
      autoFocus = props.autoFocus,
      autoComplete = props.autoComplete,
      accessibilityIndex = props.accessibilityIndex,
      tabIndex = props.tabIndex,
      removeIcon = props.removeIcon,
      choiceTransitionName = props.choiceTransitionName,
      maxTagCount = props.maxTagCount,
      maxTagTextLength = props.maxTagTextLength,
      _props$maxTagPlacehol = props.maxTagPlaceholder,
      maxTagPlaceholder = _props$maxTagPlacehol === void 0 ? function (omittedValues) {
    return "+ ".concat(omittedValues.length, " ...");
  } : _props$maxTagPlacehol,
      tagRender = props.tagRender,
      onSelect = props.onSelect,
      onInputChange = props.onInputChange,
      onInputPaste = props.onInputPaste,
      onInputKeyDown = props.onInputKeyDown,
      onInputMouseDown = props.onInputMouseDown;

  var _React$useState = _react.default.useState(false),
      _React$useState2 = (0, _slicedToArray2.default)(_React$useState, 2),
      motionAppear = _React$useState2[0],
      setMotionAppear = _React$useState2[1];

  var measureRef = _react.default.useRef(null);

  var _React$useState3 = _react.default.useState(0),
      _React$useState4 = (0, _slicedToArray2.default)(_React$useState3, 2),
      inputWidth = _React$useState4[0],
      setInputWidth = _React$useState4[1]; // ===================== Motion ======================


  _react.default.useEffect(function () {
    setMotionAppear(true);
  }, []); // ===================== Search ======================


  var inputValue = open ? searchValue : '';
  var inputEditable = mode === 'tags' || open && showSearch; // We measure width and set to the input immediately

  (0, _useLayoutEffect.default)(function () {
    setInputWidth(measureRef.current.scrollWidth);
  }, [inputValue]); // ==================== Selection ====================

  var displayValues = values; // Cut by `maxTagCount`

  var restCount;

  if (typeof maxTagCount === 'number') {
    restCount = values.length - maxTagCount;
    displayValues = values.slice(0, maxTagCount);
  } // Update by `maxTagTextLength`


  if (typeof maxTagTextLength === 'number') {
    displayValues = displayValues.map(function (_ref) {
      var label = _ref.label,
          rest = (0, _objectWithoutProperties2.default)(_ref, ["label"]);
      var displayLabel = label;

      if (typeof label === 'string' || typeof label === 'number') {
        var strLabel = String(displayLabel);

        if (strLabel.length > maxTagTextLength) {
          displayLabel = "".concat(strLabel.slice(0, maxTagTextLength), "...");
        }
      }

      return _objectSpread(_objectSpread({}, rest), {}, {
        label: displayLabel
      });
    });
  } // Fill rest


  if (restCount > 0) {
    displayValues.push({
      key: REST_TAG_KEY,
      label: typeof maxTagPlaceholder === 'function' ? maxTagPlaceholder(values.slice(maxTagCount)) : maxTagPlaceholder
    });
  }

  var selectionNode = _react.default.createElement(_CSSMotionList.default, {
    component: false,
    keys: displayValues,
    motionName: choiceTransitionName,
    motionAppear: motionAppear
  }, function (_ref2) {
    var key = _ref2.key,
        label = _ref2.label,
        value = _ref2.value,
        itemDisabled = _ref2.disabled,
        className = _ref2.className,
        style = _ref2.style;
    var mergedKey = key || value;
    var closable = key !== REST_TAG_KEY && !itemDisabled;

    var onMouseDown = function onMouseDown(event) {
      event.preventDefault();
      event.stopPropagation();
    };

    var onClose = function onClose(event) {
      if (event) event.stopPropagation();
      onSelect(value, {
        selected: false
      });
    };

    return typeof tagRender === 'function' ? _react.default.createElement("span", {
      key: mergedKey,
      onMouseDown: onMouseDown,
      className: className,
      style: style
    }, tagRender({
      label: label,
      value: value,
      disabled: itemDisabled,
      closable: closable,
      onClose: onClose
    })) : _react.default.createElement("span", {
      key: mergedKey,
      className: (0, _classnames.default)(className, "".concat(prefixCls, "-selection-item"), (0, _defineProperty2.default)({}, "".concat(prefixCls, "-selection-item-disabled"), itemDisabled)),
      style: style
    }, _react.default.createElement("span", {
      className: "".concat(prefixCls, "-selection-item-content")
    }, label), closable && _react.default.createElement(_TransBtn.default, {
      className: "".concat(prefixCls, "-selection-item-remove"),
      onMouseDown: onMouseDown,
      onClick: onClose,
      customizeIcon: removeIcon
    }, "\xD7"));
  });

  return _react.default.createElement(_react.default.Fragment, null, selectionNode, _react.default.createElement("span", {
    className: "".concat(prefixCls, "-selection-search"),
    style: {
      width: inputWidth
    }
  }, _react.default.createElement(_Input.default, {
    ref: inputRef,
    open: open,
    prefixCls: prefixCls,
    id: id,
    inputElement: null,
    disabled: disabled,
    autoFocus: autoFocus,
    autoComplete: autoComplete,
    editable: inputEditable,
    accessibilityIndex: accessibilityIndex,
    value: inputValue,
    onKeyDown: onInputKeyDown,
    onMouseDown: onInputMouseDown,
    onChange: onInputChange,
    onPaste: onInputPaste,
    tabIndex: tabIndex,
    attrs: (0, _pickAttrs.default)(props, true)
  }), _react.default.createElement("span", {
    ref: measureRef,
    className: "".concat(prefixCls, "-selection-search-mirror"),
    "aria-hidden": true
  }, inputValue, "\xA0")), !values.length && !inputValue && _react.default.createElement("span", {
    className: "".concat(prefixCls, "-selection-placeholder")
  }, placeholder));
};

var _default = SelectSelector;
exports.default = _default;