"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var React = _interopRequireWildcard(require("react"));

var _KeyCode = _interopRequireDefault(require("rc-util/lib/KeyCode"));

var _MultipleSelector = _interopRequireDefault(require("./MultipleSelector"));

var _SingleSelector = _interopRequireDefault(require("./SingleSelector"));

var _useLock3 = _interopRequireDefault(require("../hooks/useLock"));

/**
 * Cursor rule:
 * 1. Only `showSearch` enabled
 * 2. Only `open` is `true`
 * 3. When typing, set `open` to `true` which hit rule of 2
 *
 * Accessibility:
 * - https://www.w3.org/TR/wai-aria-practices/examples/combobox/aria1.1pattern/listbox-combo.html
 */
var Selector = function Selector(props, ref) {
  var inputRef = React.useRef(null);
  var prefixCls = props.prefixCls,
      multiple = props.multiple,
      open = props.open,
      mode = props.mode,
      showSearch = props.showSearch,
      onSearch = props.onSearch,
      onToggleOpen = props.onToggleOpen,
      onInputKeyDown = props.onInputKeyDown,
      domRef = props.domRef; // ======================= Ref =======================

  React.useImperativeHandle(ref, function () {
    return {
      focus: function focus() {
        inputRef.current.focus();
      },
      blur: function blur() {
        inputRef.current.blur();
      }
    };
  }); // ====================== Input ======================

  var _useLock = (0, _useLock3.default)(0),
      _useLock2 = (0, _slicedToArray2.default)(_useLock, 2),
      getInputMouseDown = _useLock2[0],
      setInputMouseDown = _useLock2[1];

  var onInternalInputKeyDown = function onInternalInputKeyDown(event) {
    var which = event.which;

    if (which === _KeyCode.default.UP || which === _KeyCode.default.DOWN) {
      event.preventDefault();
    }

    if (onInputKeyDown) {
      onInputKeyDown(event);
    }

    if (![_KeyCode.default.SHIFT, _KeyCode.default.TAB, _KeyCode.default.BACKSPACE, _KeyCode.default.ESC].includes(which)) {
      onToggleOpen(true);
    }
  };
  /**
   * We can not use `findDOMNode` sine it will get warning,
   * have to use timer to check if is input element.
   */


  var onInternalInputMouseDown = function onInternalInputMouseDown() {
    setInputMouseDown(true);
  }; // When paste come, ignore next onChange


  var pasteClearRef = React.useRef(false);

  var triggerOnSearch = function triggerOnSearch(value) {
    if (onSearch(value) !== false) {
      onToggleOpen(true);
    }
  };

  var onInputChange = function onInputChange(_ref) {
    var value = _ref.target.value;

    if (pasteClearRef.current) {
      pasteClearRef.current = false;
      return;
    }

    triggerOnSearch(value);
  };

  var onInputPaste = function onInputPaste(e) {
    // github.com/ant-design/ant-design/issues/24461
    if (e.target.value) {
      return;
    }

    var clipboardData = e.clipboardData;
    var value = clipboardData.getData('text'); // Block next onChange

    pasteClearRef.current = true;
    setTimeout(function () {
      pasteClearRef.current = false;
    });
    triggerOnSearch(value);
  }; // ====================== Focus ======================
  // Should focus input if click the selector


  var onClick = function onClick(_ref2) {
    var target = _ref2.target;

    if (target !== inputRef.current) {
      inputRef.current.focus();
    }
  };

  var onMouseDown = function onMouseDown(event) {
    var inputMouseDown = getInputMouseDown();

    if (event.target !== inputRef.current && !inputMouseDown) {
      event.preventDefault();
    }

    if (mode !== 'combobox' && (!showSearch || !inputMouseDown) || !open) {
      if (open) {
        onSearch('');
      }

      onToggleOpen();
    }
  }; // ================= Inner Selector ==================


  var sharedProps = {
    inputRef: inputRef,
    onInputKeyDown: onInternalInputKeyDown,
    onInputMouseDown: onInternalInputMouseDown,
    onInputChange: onInputChange,
    onInputPaste: onInputPaste
  };
  var selectNode = multiple ? React.createElement(_MultipleSelector.default, Object.assign({}, props, sharedProps)) : React.createElement(_SingleSelector.default, Object.assign({}, props, sharedProps));
  return React.createElement("div", {
    ref: domRef,
    className: "".concat(prefixCls, "-selector"),
    onClick: onClick,
    onMouseDown: onMouseDown
  }, selectNode);
};

var ForwardSelector = React.forwardRef(Selector);
ForwardSelector.displayName = 'Selector';
var _default = ForwardSelector;
exports.default = _default;