"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _createSuper2 = _interopRequireDefault(require("@babel/runtime/helpers/createSuper"));

var React = _interopRequireWildcard(require("react"));

var _OptionList = _interopRequireDefault(require("./OptionList"));

var _Option = _interopRequireDefault(require("./Option"));

var _OptGroup = _interopRequireDefault(require("./OptGroup"));

var _legacyUtil = require("./utils/legacyUtil");

var _valueUtil = require("./utils/valueUtil");

var _generate = _interopRequireDefault(require("./generate"));

var _warningPropsUtil = _interopRequireDefault(require("./utils/warningPropsUtil"));

/**
 * To match accessibility requirement, we always provide an input in the component.
 * Other element will not set `tabIndex` to avoid `onBlur` sequence problem.
 * For focused select, we set `aria-live="polite"` to update the accessibility content.
 *
 * ref:
 * - keyboard: https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Roles/listbox_role#Keyboard_interactions
 *
 * New api:
 * - listHeight
 * - listItemHeight
 * - component
 *
 * Remove deprecated api:
 * - multiple
 * - tags
 * - combobox
 * - firstActiveValue
 * - dropdownMenuStyle
 * - openClassName (Not list in api)
 *
 * Update:
 * - `backfill` only support `combobox` mode
 * - `combobox` mode not support `labelInValue` since it's meaningless
 * - `getInputElement` only support `combobox` mode
 * - `onChange` return OptionData instead of ReactNode
 * - `filterOption` `onChange` `onSelect` accept OptionData instead of ReactNode
 * - `combobox` mode trigger `onChange` will get `undefined` if no `value` match in Option
 * - `combobox` mode not support `optionLabelProp`
 */
var RefSelect = (0, _generate.default)({
  prefixCls: 'rc-select',
  components: {
    optionList: _OptionList.default
  },
  convertChildrenToData: _legacyUtil.convertChildrenToData,
  flattenOptions: _valueUtil.flattenOptions,
  getLabeledValue: _valueUtil.getLabeledValue,
  filterOptions: _valueUtil.filterOptions,
  isValueDisabled: _valueUtil.isValueDisabled,
  findValueOption: _valueUtil.findValueOption,
  warningProps: _warningPropsUtil.default,
  fillOptionsWithMissingValue: _valueUtil.fillOptionsWithMissingValue
});
/**
 * Typescript not support generic with function component,
 * we have to wrap an class component to handle this.
 */

var Select = /*#__PURE__*/function (_React$Component) {
  (0, _inherits2.default)(Select, _React$Component);

  var _super = (0, _createSuper2.default)(Select);

  function Select() {
    var _this;

    (0, _classCallCheck2.default)(this, Select);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));
    _this.selectRef = /*#__PURE__*/React.createRef();

    _this.focus = function () {
      _this.selectRef.current.focus();
    };

    _this.blur = function () {
      _this.selectRef.current.blur();
    };

    return _this;
  }

  (0, _createClass2.default)(Select, [{
    key: "render",
    value: function render() {
      return /*#__PURE__*/React.createElement(RefSelect, (0, _extends2.default)({
        ref: this.selectRef
      }, this.props));
    }
  }]);
  return Select;
}(React.Component);

Select.Option = _Option.default;
Select.OptGroup = _OptGroup.default;
var _default = Select;
exports.default = _default;