'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectPropTypes = undefined;

var _react = require('react');

function valueType(props, propName, componentName) {
  var labelInValueShape = _react.PropTypes.shape({
    key: _react.PropTypes.string.isRequired,
    label: _react.PropTypes.string
  });
  if (props.labelInValue) {
    var validate = _react.PropTypes.oneOfType([_react.PropTypes.arrayOf(labelInValueShape), labelInValueShape]);
    var error = validate.apply(undefined, arguments);
    if (error) {
      return new Error('Invalid prop `' + propName + '` supplied to `' + componentName + '`, ' + ('when you set `labelInValue` to `true`, `' + propName + '` should in ') + 'shape of `{ key: string, label?: string }`.');
    }
  } else if (props.multiple && props[propName] === '') {
    return new Error('Invalid prop `' + propName + '` of type `string` supplied to `' + componentName + '`, ' + 'expected `array` when `multiple` is `true`.');
  } else {
    var _validate = _react.PropTypes.oneOfType([_react.PropTypes.arrayOf(_react.PropTypes.string), _react.PropTypes.string]);
    return _validate.apply(undefined, arguments);
  }
}

var SelectPropTypes = exports.SelectPropTypes = {
  defaultActiveFirstOption: _react.PropTypes.bool,
  multiple: _react.PropTypes.bool,
  filterOption: _react.PropTypes.any,
  children: _react.PropTypes.any,
  showSearch: _react.PropTypes.bool,
  disabled: _react.PropTypes.bool,
  allowClear: _react.PropTypes.bool,
  showArrow: _react.PropTypes.bool,
  tags: _react.PropTypes.bool,
  prefixCls: _react.PropTypes.string,
  className: _react.PropTypes.string,
  transitionName: _react.PropTypes.string,
  optionLabelProp: _react.PropTypes.string,
  optionFilterProp: _react.PropTypes.string,
  animation: _react.PropTypes.string,
  choiceTransitionName: _react.PropTypes.string,
  onChange: _react.PropTypes.func,
  onBlur: _react.PropTypes.func,
  onFocus: _react.PropTypes.func,
  onSelect: _react.PropTypes.func,
  onSearch: _react.PropTypes.func,
  placeholder: _react.PropTypes.any,
  onDeselect: _react.PropTypes.func,
  labelInValue: _react.PropTypes.bool,
  value: valueType,
  defaultValue: valueType,
  dropdownStyle: _react.PropTypes.object,
  maxTagTextLength: _react.PropTypes.number,
  tokenSeparators: _react.PropTypes.arrayOf(_react.PropTypes.string),
  getInputElement: _react.PropTypes.func
};