import _extends from 'babel-runtime/helpers/extends';
import React, { cloneElement } from 'react';
import { findDOMNode } from 'react-dom';
import PropTypes from 'prop-types';
import createClass from 'create-react-class';
import toArray from 'rc-util/es/Children/toArray';
import Menu from 'rc-menu';
import scrollIntoView from 'dom-scroll-into-view';
import { getSelectKeys, preventDefaultEvent } from './util';

var DropdownMenu = createClass({
  propTypes: {
    defaultActiveFirstOption: PropTypes.bool,
    value: PropTypes.any,
    dropdownMenuStyle: PropTypes.object,
    multiple: PropTypes.bool,
    onPopupFocus: PropTypes.func,
    onMenuDeSelect: PropTypes.func,
    onMenuSelect: PropTypes.func,
    prefixCls: PropTypes.string,
    menuItems: PropTypes.any,
    inputValue: PropTypes.string,
    visible: PropTypes.bool
  },

  componentWillMount: function componentWillMount() {
    this.lastInputValue = this.props.inputValue;
  },
  componentDidMount: function componentDidMount() {
    this.scrollActiveItemToView();
    this.lastVisible = this.props.visible;
  },
  shouldComponentUpdate: function shouldComponentUpdate(nextProps) {
    if (!nextProps.visible) {
      this.lastVisible = false;
    }
        return nextProps.visible;
  },
  componentDidUpdate: function componentDidUpdate(prevProps) {
    var props = this.props;
    if (!prevProps.visible && props.visible) {
      this.scrollActiveItemToView();
    }
    this.lastVisible = props.visible;
    this.lastInputValue = props.inputValue;
  },
  scrollActiveItemToView: function scrollActiveItemToView() {
        var itemComponent = findDOMNode(this.firstActiveItem);
    if (itemComponent) {
      scrollIntoView(itemComponent, findDOMNode(this.refs.menu), {
        onlyScrollIfNeeded: true
      });
    }
  },
  renderMenu: function renderMenu() {
    var _this = this;

    var props = this.props;
    var menuItems = props.menuItems,
        defaultActiveFirstOption = props.defaultActiveFirstOption,
        value = props.value,
        prefixCls = props.prefixCls,
        multiple = props.multiple,
        onMenuSelect = props.onMenuSelect,
        inputValue = props.inputValue;

    if (menuItems && menuItems.length) {
      var menuProps = {};
      if (multiple) {
        menuProps.onDeselect = props.onMenuDeselect;
        menuProps.onSelect = onMenuSelect;
      } else {
        menuProps.onClick = onMenuSelect;
      }

      var selectedKeys = getSelectKeys(menuItems, value);
      var activeKeyProps = {};

      var clonedMenuItems = menuItems;
      if (selectedKeys.length) {
        if (props.visible && !this.lastVisible) {
          activeKeyProps.activeKey = selectedKeys[0];
        }
        var foundFirst = false;
                        var clone = function clone(item) {
          if (!foundFirst && selectedKeys.indexOf(item.key) !== -1) {
            foundFirst = true;
            return cloneElement(item, {
              ref: function ref(_ref) {
                _this.firstActiveItem = _ref;
              }
            });
          }
          return item;
        };

        clonedMenuItems = menuItems.map(function (item) {
          if (item.type.isMenuItemGroup) {
            var children = toArray(item.props.children).map(clone);
            return cloneElement(item, {}, children);
          }
          return clone(item);
        });
      }

            if (inputValue !== this.lastInputValue) {
        activeKeyProps.activeKey = '';
      }

      return React.createElement(
        Menu,
        _extends({
          ref: 'menu',
          style: this.props.dropdownMenuStyle,
          defaultActiveFirst: defaultActiveFirstOption
        }, activeKeyProps, {
          multiple: multiple,
          focusable: false
        }, menuProps, {
          selectedKeys: selectedKeys,
          prefixCls: prefixCls + '-menu'
        }),
        clonedMenuItems
      );
    }
    return null;
  },
  render: function render() {
    var renderMenu = this.renderMenu();
    return renderMenu ? React.createElement(
      'div',
      {
        style: { overflow: 'auto' },
        onFocus: this.props.onPopupFocus,
        onMouseDown: preventDefaultEvent
      },
      renderMenu
    ) : null;
  }
});

DropdownMenu.displayName = 'DropdownMenu';
export default DropdownMenu;