import _extends from 'babel-runtime/helpers/extends';
import React from 'react';
import { getValuePropValue, defaultFilterFn, UNSELECTABLE_ATTRIBUTE, UNSELECTABLE_STYLE } from './util';
import { Item as MenuItem, ItemGroup as MenuItemGroup } from 'rc-menu';
import warning from 'warning';

export default {
  filterOption: function filterOption(input, child) {
    var defaultFilter = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : defaultFilterFn;

    if (!input) {
      return true;
    }
    var filterOption = 'filterOption' in this.props ? this.props.filterOption : defaultFilter;
    if (!filterOption) {
      return true;
    } else if (child.props.disabled) {
      return false;
    } else if (typeof filterOption === 'function') {
      return filterOption.call(this, input, child);
    }
    return true;
  },
  renderFilterOptions: function renderFilterOptions(inputValue) {
    return this.renderFilterOptionsFromChildren(this.props.children, true, inputValue);
  },
  renderFilterOptionsFromChildren: function renderFilterOptionsFromChildren(children, showNotFound, iv) {
    var _this = this;

    var sel = [];
    var props = this.props;
    var inputValue = iv === undefined ? this.state.inputValue : iv;
    var childrenKeys = [];
    var tags = props.tags;
    React.Children.forEach(children, function (child) {
      if (child.type.isSelectOptGroup) {
        var innerItems = _this.renderFilterOptionsFromChildren(child.props.children, false);
        if (innerItems.length) {
          var label = child.props.label;
          var key = child.key;
          if (!key && typeof label === 'string') {
            key = label;
          } else if (!label && key) {
            label = key;
          }
          sel.push(React.createElement(
            MenuItemGroup,
            { key: key, title: label },
            innerItems
          ));
        }
        return;
      }

      warning(child.type.isSelectOption, 'the children of `Select` should be `Select.Option` or `Select.OptGroup`, ' + ('instead of `' + (child.type.name || child.type.displayName || child.type) + '`.'));

      var childValue = getValuePropValue(child);
      if (_this.filterOption(inputValue, child)) {
        sel.push(React.createElement(MenuItem, _extends({
          style: UNSELECTABLE_STYLE,
          attribute: UNSELECTABLE_ATTRIBUTE,
          value: childValue,
          key: childValue
        }, child.props)));
      }
      if (tags && !child.props.disabled) {
        childrenKeys.push(childValue);
      }
    });
    if (tags) {
      // tags value must be string
      var value = this.state.value || [];
      value = value.filter(function (singleValue) {
        return childrenKeys.indexOf(singleValue.key) === -1 && (!inputValue || String(singleValue.key).indexOf(String(inputValue)) > -1);
      });
      sel = sel.concat(value.map(function (singleValue) {
        var key = singleValue.key;
        return React.createElement(
          MenuItem,
          {
            style: UNSELECTABLE_STYLE,
            attribute: UNSELECTABLE_ATTRIBUTE,
            value: key,
            key: key
          },
          key
        );
      }));
      if (inputValue) {
        var notFindInputItem = sel.every(function (option) {
          return !_this.filterOption.call(_this, inputValue, option, function () {
            return getValuePropValue(option) === inputValue;
          });
        });
        if (notFindInputItem) {
          sel.unshift(React.createElement(
            MenuItem,
            {
              style: UNSELECTABLE_STYLE,
              attribute: UNSELECTABLE_ATTRIBUTE,
              value: inputValue,
              key: inputValue
            },
            inputValue
          ));
        }
      }
    }
    if (!sel.length && showNotFound && props.notFoundContent) {
      sel = [React.createElement(
        MenuItem,
        {
          style: UNSELECTABLE_STYLE,
          attribute: UNSELECTABLE_ATTRIBUTE,
          disabled: true,
          value: 'NOT_FOUND',
          key: 'NOT_FOUND'
        },
        props.notFoundContent
      )];
    }
    return sel;
  }
};