import * as React from 'react';
import OptGroup from './OptGroup';
import Option from './Option';
import { IILableValueType, ISelectProps, valueType } from './PropTypes';
import SelectTrigger from './SelectTrigger';
import { defaultFilterFn } from './util';
export interface ISelectState {
    open: boolean;
    value?: valueType;
    inputValue?: string;
    skipBuildOptionsInfo?: boolean;
    optionsInfo?: any;
    backfillValue?: string;
    ariaId?: string;
}
declare class Select extends React.Component<Partial<ISelectProps>, ISelectState> {
    static propTypes: {
        id: import("prop-types").Requireable<string>;
        defaultActiveFirstOption: import("prop-types").Requireable<boolean>;
        multiple: import("prop-types").Requireable<boolean>;
        filterOption: import("prop-types").Requireable<any>;
        children: import("prop-types").Requireable<any>;
        showSearch: import("prop-types").Requireable<boolean>;
        disabled: import("prop-types").Requireable<boolean>;
        allowClear: import("prop-types").Requireable<boolean>;
        showArrow: import("prop-types").Requireable<boolean>;
        tags: import("prop-types").Requireable<boolean>;
        prefixCls: import("prop-types").Requireable<string>;
        className: import("prop-types").Requireable<string>;
        transitionName: import("prop-types").Requireable<string>;
        optionLabelProp: import("prop-types").Requireable<string>;
        optionFilterProp: import("prop-types").Requireable<string>;
        animation: import("prop-types").Requireable<string>;
        choiceTransitionName: import("prop-types").Requireable<string>;
        open: import("prop-types").Requireable<boolean>;
        defaultOpen: import("prop-types").Requireable<boolean>;
        onChange: import("prop-types").Requireable<(...args: any[]) => any>;
        onBlur: import("prop-types").Requireable<(...args: any[]) => any>;
        onFocus: import("prop-types").Requireable<(...args: any[]) => any>;
        onSelect: import("prop-types").Requireable<(...args: any[]) => any>;
        onSearch: import("prop-types").Requireable<(...args: any[]) => any>;
        onPopupScroll: import("prop-types").Requireable<(...args: any[]) => any>;
        onMouseEnter: import("prop-types").Requireable<(...args: any[]) => any>;
        onMouseLeave: import("prop-types").Requireable<(...args: any[]) => any>;
        onInputKeyDown: import("prop-types").Requireable<(...args: any[]) => any>;
        placeholder: import("prop-types").Requireable<any>;
        onDeselect: import("prop-types").Requireable<(...args: any[]) => any>;
        labelInValue: import("prop-types").Requireable<boolean>;
        loading: import("prop-types").Requireable<boolean>;
        value: (args_0: ISelectProps, args_1: string, args_2: string, args_3: any, args_4: any) => Error | null;
        defaultValue: (args_0: ISelectProps, args_1: string, args_2: string, args_3: any, args_4: any) => Error | null;
        dropdownStyle: import("prop-types").Requireable<object>;
        maxTagTextLength: import("prop-types").Requireable<number>;
        maxTagCount: import("prop-types").Requireable<number>;
        maxTagPlaceholder: import("prop-types").Requireable<string | number | boolean | {} | import("prop-types").ReactElementLike | import("prop-types").ReactNodeArray>;
        tokenSeparators: import("prop-types").Requireable<(string | null)[]>;
        getInputElement: import("prop-types").Requireable<(...args: any[]) => any>;
        showAction: import("prop-types").Requireable<(string | null)[]>;
        clearIcon: import("prop-types").Requireable<import("prop-types").ReactNodeLike>;
        inputIcon: import("prop-types").Requireable<import("prop-types").ReactNodeLike>;
        removeIcon: import("prop-types").Requireable<import("prop-types").ReactNodeLike>;
        menuItemSelectedIcon: import("prop-types").Requireable<string | number | boolean | {} | import("prop-types").ReactElementLike | import("prop-types").ReactNodeArray>;
        dropdownRender: import("prop-types").Requireable<(...args: any[]) => any>;
    };
    static Option: typeof Option;
    static OptGroup: typeof OptGroup;
    static displayName: string;
    static defaultProps: {
        prefixCls: string;
        defaultOpen: boolean;
        labelInValue: boolean;
        defaultActiveFirstOption: boolean;
        showSearch: boolean;
        allowClear: boolean;
        placeholder: string;
        onChange: () => null;
        onFocus: () => null;
        onBlur: () => null;
        onSelect: () => null;
        onSearch: () => null;
        onDeselect: () => null;
        onInputKeyDown: () => null;
        dropdownMatchSelectWidth: boolean;
        dropdownStyle: {};
        dropdownMenuStyle: {};
        optionFilterProp: string;
        optionLabelProp: string;
        notFoundContent: string;
        backfill: boolean;
        showAction: string[];
        tokenSeparators: never[];
        autoClearSearchValue: boolean;
        tabIndex: number;
        dropdownRender: (menu: any) => any;
    };
    static getDerivedStateFromProps: (nextProps: ISelectProps, prevState: ISelectState) => Partial<ISelectState>;
    static getOptionsFromChildren: (children: React.ReactElement<any, string | ((props: any) => React.ReactElement<any, string | any | (new (props: any) => React.Component<any, any, any>)> | null) | (new (props: any) => React.Component<any, any, any>)>[], options?: any[]) => any[];
    static getInputValueForCombobox: (props: Partial<ISelectProps>, optionsInfo: any, useDefaultValue?: boolean | undefined) => string;
    static getLabelFromOption: (props: Partial<ISelectProps>, option: any) => any;
    static getOptionsInfoFromProps: (props: Partial<ISelectProps>, preState?: ISelectState | undefined) => {};
    static getValueFromProps: (props: Partial<ISelectProps>, useDefaultValue?: boolean | undefined) => string | number | string[] | number[] | IILableValueType | IILableValueType[] | undefined;
    saveInputRef: (ref: HTMLInputElement) => void;
    saveInputMirrorRef: (ref: HTMLSpanElement) => void;
    saveTopCtrlRef: (ref: HTMLDivElement) => void;
    saveSelectTriggerRef: (ref: SelectTrigger) => void;
    saveRootRef: (ref: HTMLDivElement) => void;
    saveSelectionRef: (ref: HTMLDivElement) => void;
    inputRef: HTMLInputElement | null;
    inputMirrorRef: HTMLSpanElement | null;
    topCtrlRef: HTMLDivElement | null;
    selectTriggerRef: SelectTrigger | null;
    rootRef: HTMLDivElement | null;
    selectionRef: HTMLDivElement | null;
    dropdownContainer: Element | null;
    blurTimer: number | null;
    focusTimer: number | null;
    private _focused;
    private _mouseDown;
    private _options;
    private _empty;
    constructor(props: Partial<ISelectProps>);
    componentDidMount(): void;
    componentDidUpdate(): void;
    componentWillUnmount(): void;
    onInputChange: (event: React.ChangeEvent<HTMLInputElement>) => void;
    onDropdownVisibleChange: (open: boolean) => void;
    onKeyDown: (event: KeyboardEvent) => void;
    onInputKeyDown: (event: KeyboardEvent | React.ChangeEvent<HTMLInputElement>) => void;
    onMenuSelect: ({ item }: {
        item: Option;
    }) => void;
    onMenuDeselect: ({ item, domEvent }: {
        item: any;
        domEvent: KeyboardEvent;
    }) => void;
    onArrowClick: (e: React.MouseEvent<HTMLIFrameElement, MouseEvent>) => void;
    onPlaceholderClick: () => void;
    onOuterFocus: (e: React.FocusEvent<HTMLInputElement> | React.FocusEvent<HTMLDivElement>) => void;
    onPopupFocus: () => void;
    onOuterBlur: (e: React.FocusEvent<HTMLDivElement>) => void;
    onClearSelection: (event: Event) => void;
    onChoiceAnimationLeave: () => void;
    getOptionInfoBySingleValue: (value: valueType, optionsInfo?: any) => any;
    getOptionBySingleValue: (value: valueType) => any;
    getOptionsBySingleValue: (values: valueType) => any[];
    getValueByLabel: (label?: string | undefined) => null;
    getVLBySingleValue: (value: valueType) => string | number | string[] | number[] | IILableValueType | IILableValueType[] | {
        key: valueType;
        label: any;
    };
    getVLForOnChange: (vlsS: valueType) => valueType;
    getLabelBySingleValue: (value: valueType, optionsInfo?: any) => any;
    getDropdownContainer: () => Element;
    getPlaceholderElement: () => JSX.Element | null;
    getInputElement: () => JSX.Element;
    getInputDOMNode: () => HTMLInputElement | null;
    getInputMirrorDOMNode: () => HTMLSpanElement | null;
    getPopupDOMNode: () => any;
    getPopupMenuComponent: () => any;
    setOpenState: (open: boolean, needFocus?: boolean | undefined) => void;
    setInputValue: (inputValue: string, fireSearch?: boolean) => void;
    getValueByInput: (str: string | string[]) => string | number | string[] | number[] | IILableValueType | IILableValueType[] | undefined;
    getRealOpenState: (state?: ISelectState | undefined) => boolean;
    focus(): void;
    blur(): void;
    markMouseDown: () => void;
    markMouseLeave: () => void;
    handleBackfill: (item: JSX.Element) => void;
    filterOption: (input: string, child: JSX.Element, defaultFilter?: typeof defaultFilterFn) => boolean | void;
    timeoutFocus: () => void;
    clearFocusTime: () => void;
    clearBlurTime: () => void;
    updateFocusClassName: () => void;
    maybeFocus: (open: boolean, needFocus: boolean) => void;
    removeSelected: (selectedKey: string | string[], e?: React.MouseEvent<HTMLSpanElement, MouseEvent> | undefined) => void;
    openIfHasChildren: () => void;
    fireSelect: (value: valueType) => void;
    fireChange: (value: valueType) => void;
    isChildDisabled: (key: string | string[]) => any;
    forcePopupAlign: () => void;
    renderFilterOptions: () => {
        empty: boolean;
        options: JSX.Element[];
    };
    renderFilterOptionsFromChildren: (children: React.ReactElement<any, string | ((props: any) => React.ReactElement<any, string | any | (new (props: any) => React.Component<any, any, any>)> | null) | (new (props: any) => React.Component<any, any, any>)>[], childrenKeys: string[], menuItems: JSX.Element[]) => JSX.Element[];
    renderTopControlNode: () => JSX.Element;
    renderArrow(multiple: boolean): JSX.Element | null;
    renderClear(): JSX.Element | null;
    render(): JSX.Element;
}
export default Select;
