'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _rcTooltip = require('rc-tooltip');

var _rcTooltip2 = _interopRequireDefault(_rcTooltip);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var Handle = function (_React$Component) {
  (0, _inherits3["default"])(Handle, _React$Component);

  function Handle(props) {
    (0, _classCallCheck3["default"])(this, Handle);

    var _this = (0, _possibleConstructorReturn3["default"])(this, _React$Component.call(this, props));

    _this.state = {
      isTooltipVisible: false
    };
    return _this;
  }

  Handle.prototype.hideTooltip = function hideTooltip() {
    this.setState({
      isTooltipVisible: false
    });
  };

  Handle.prototype.showTooltip = function showTooltip() {
    this.setState({
      isTooltipVisible: true
    });
  };

  Handle.prototype.render = function render() {
    var _props = this.props,
        prefixCls = _props.prefixCls,
        tooltipPrefixCls = _props.tooltipPrefixCls,
        className = _props.className,
        tipTransitionName = _props.tipTransitionName,
        tipFormatter = _props.tipFormatter,
        vertical = _props.vertical,
        offset = _props.offset,
        value = _props.value,
        dragging = _props.dragging,
        noTip = _props.noTip,
        index = _props.index;


    var style = vertical ? { bottom: offset + '%' } : { left: offset + '%' };
    var handle = _react2["default"].createElement('div', { className: className, style: style,
      onMouseUp: this.showTooltip.bind(this),
      onMouseEnter: this.showTooltip.bind(this),
      onMouseLeave: this.hideTooltip.bind(this)
    });

    if (noTip) {
      return handle;
    }

    var isTooltipVisible = dragging || this.state.isTooltipVisible;
    return _react2["default"].createElement(
      _rcTooltip2["default"],
      {
        prefixCls: tooltipPrefixCls || prefixCls + '-tooltip',
        placement: 'top',
        visible: isTooltipVisible,
        overlay: _react2["default"].createElement(
          'span',
          null,
          tipFormatter(value, index)
        ),
        delay: 0,
        transitionName: tipTransitionName
      },
      handle
    );
  };

  return Handle;
}(_react2["default"].Component);

exports["default"] = Handle;


Handle.propTypes = {
  prefixCls: _react2["default"].PropTypes.string,
  tooltipPrefixCls: _react2["default"].PropTypes.string,
  className: _react2["default"].PropTypes.string,
  vertical: _react2["default"].PropTypes.bool,
  offset: _react2["default"].PropTypes.number,
  tipTransitionName: _react2["default"].PropTypes.string,
  tipFormatter: _react2["default"].PropTypes.func,
  value: _react2["default"].PropTypes.number,
  dragging: _react2["default"].PropTypes.bool,
  noTip: _react2["default"].PropTypes.bool,
  index: _react2["default"].PropTypes.number
};
module.exports = exports['default'];