import React from 'react';
import { Status, Icons } from './interface';
import { StepIconRender, ProgressDotRender } from './Steps';
export interface StepProps {
    prefixCls?: string;
    className?: string;
    style?: React.CSSProperties;
    wrapperStyle?: React.CSSProperties;
    iconPrefix?: string;
    active?: boolean;
    disabled?: boolean;
    stepIndex?: number;
    stepNumber?: number;
    status?: Status;
    title?: React.ReactNode;
    subTitle?: React.ReactNode;
    description?: React.ReactNode;
    tailContent?: React.ReactNode;
    icon?: React.ReactNode;
    icons?: Icons;
    onClick?: React.MouseEventHandler<HTMLDivElement>;
    onStepClick?: (index: number) => void;
    progressDot?: ProgressDotRender | boolean;
    stepIcon?: StepIconRender;
}
export default class Step extends React.Component<StepProps> {
    onClick: React.MouseEventHandler<HTMLDivElement>;
    renderIconNode(): any;
    render(): JSX.Element;
}
