'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _shallowequal = require('shallowequal');

var _shallowequal2 = _interopRequireDefault(_shallowequal);

var _TableCell = require('./TableCell');

var _TableCell2 = _interopRequireDefault(_TableCell);

var _ExpandIcon = require('./ExpandIcon');

var _ExpandIcon2 = _interopRequireDefault(_ExpandIcon);

var _ColumnManager = require('./ColumnManager');

var _ColumnManager2 = _interopRequireDefault(_ColumnManager);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var TableRow = _react2["default"].createClass({
  displayName: 'TableRow',

  propTypes: {
    onDestroy: _react.PropTypes.func,
    onRowClick: _react.PropTypes.func,
    onRowDoubleClick: _react.PropTypes.func,
    record: _react.PropTypes.object,
    prefixCls: _react.PropTypes.string,
    expandIconColumnIndex: _react.PropTypes.number,
    onHover: _react.PropTypes.func,
    columns: _react.PropTypes.array,
    height: _react.PropTypes.oneOfType([_react.PropTypes.string, _react.PropTypes.number]),
    visible: _react.PropTypes.bool,
    index: _react.PropTypes.number,
    hoverKey: _react.PropTypes.any,
    expanded: _react.PropTypes.bool,
    expandable: _react.PropTypes.any,
    onExpand: _react.PropTypes.func,
    needIndentSpaced: _react.PropTypes.bool,
    className: _react.PropTypes.string,
    indent: _react.PropTypes.number,
    indentSize: _react.PropTypes.number,
    expandIconAsCell: _react.PropTypes.bool,
    expandRowByClick: _react.PropTypes.bool,
    store: _react.PropTypes.object.isRequired
  },

  getDefaultProps: function getDefaultProps() {
    return {
      onRowClick: function onRowClick() {},
      onRowDoubleClick: function onRowDoubleClick() {},
      onDestroy: function onDestroy() {},

      expandIconColumnIndex: 0,
      expandRowByClick: false,
      onHover: function onHover() {}
    };
  },
  getInitialState: function getInitialState() {
    return {
      hovered: false
    };
  },
  componentDidMount: function componentDidMount() {
    var _this = this;

    var _props = this.props,
        store = _props.store,
        hoverKey = _props.hoverKey;

    this.unsubscribe = store.subscribe(function () {
      if (store.getState().currentHoverKey === hoverKey) {
        _this.setState({ hovered: true });
      } else if (_this.state.hovered === true) {
        _this.setState({ hovered: false });
      }
    });
  },
  shouldComponentUpdate: function shouldComponentUpdate(nextProps, nextState) {
    return !(0, _shallowequal2["default"])(nextProps, this.props) || _ColumnManager2["default"].includesCustomRender(nextProps.columns) || !(0, _shallowequal2["default"])(nextState, this.state);
  },
  componentWillUnmount: function componentWillUnmount() {
    this.props.onDestroy(this.props.record);
    if (this.unsubscribe) {
      this.unsubscribe();
    }
  },
  onRowClick: function onRowClick(event) {
    var _props2 = this.props,
        record = _props2.record,
        index = _props2.index,
        onRowClick = _props2.onRowClick,
        expandable = _props2.expandable,
        expandRowByClick = _props2.expandRowByClick,
        expanded = _props2.expanded,
        onExpand = _props2.onExpand;

    if (expandable && expandRowByClick) {
      onExpand(!expanded, record);
    }
    onRowClick(record, index, event);
  },
  onRowDoubleClick: function onRowDoubleClick(event) {
    var _props3 = this.props,
        record = _props3.record,
        index = _props3.index,
        onRowDoubleClick = _props3.onRowDoubleClick;

    onRowDoubleClick(record, index, event);
  },
  onMouseEnter: function onMouseEnter() {
    var _props4 = this.props,
        onHover = _props4.onHover,
        hoverKey = _props4.hoverKey;

    onHover(true, hoverKey);
  },
  onMouseLeave: function onMouseLeave() {
    var _props5 = this.props,
        onHover = _props5.onHover,
        hoverKey = _props5.hoverKey;

    onHover(false, hoverKey);
  },
  render: function render() {
    var _props6 = this.props,
        prefixCls = _props6.prefixCls,
        columns = _props6.columns,
        record = _props6.record,
        height = _props6.height,
        visible = _props6.visible,
        index = _props6.index,
        expandIconColumnIndex = _props6.expandIconColumnIndex,
        expandIconAsCell = _props6.expandIconAsCell,
        expanded = _props6.expanded,
        expandRowByClick = _props6.expandRowByClick,
        expandable = _props6.expandable,
        onExpand = _props6.onExpand,
        needIndentSpaced = _props6.needIndentSpaced,
        indent = _props6.indent,
        indentSize = _props6.indentSize;
    var className = this.props.className;


    if (this.state.hovered) {
      className += ' ' + prefixCls + '-hover';
    }

    var cells = [];

    var expandIcon = _react2["default"].createElement(_ExpandIcon2["default"], {
      expandable: expandable,
      prefixCls: prefixCls,
      onExpand: onExpand,
      needIndentSpaced: needIndentSpaced,
      expanded: expanded,
      record: record
    });

    for (var i = 0; i < columns.length; i++) {
      if (expandIconAsCell && i === 0) {
        cells.push(_react2["default"].createElement(
          'td',
          {
            className: prefixCls + '-expand-icon-cell',
            key: 'rc-table-expand-icon-cell'
          },
          expandIcon
        ));
      }
      var isColumnHaveExpandIcon = expandIconAsCell || expandRowByClick ? false : i === expandIconColumnIndex;
      cells.push(_react2["default"].createElement(_TableCell2["default"], {
        prefixCls: prefixCls,
        record: record,
        indentSize: indentSize,
        indent: indent,
        index: index,
        column: columns[i],
        key: columns[i].key,
        expandIcon: isColumnHaveExpandIcon ? expandIcon : null
      }));
    }
    var style = { height: height };
    if (!visible) {
      style.display = 'none';
    }

    return _react2["default"].createElement(
      'tr',
      {
        onClick: this.onRowClick,
        onDoubleClick: this.onRowDoubleClick,
        onMouseEnter: this.onMouseEnter,
        onMouseLeave: this.onMouseLeave,
        className: prefixCls + ' ' + className + ' ' + prefixCls + '-level-' + indent,
        style: style
      },
      cells
    );
  }
});

exports["default"] = TableRow;
module.exports = exports['default'];