import _extends from 'babel-runtime/helpers/extends';
import _toConsumableArray from 'babel-runtime/helpers/toConsumableArray';
import _classCallCheck from 'babel-runtime/helpers/classCallCheck';
import _createClass from 'babel-runtime/helpers/createClass';
import _possibleConstructorReturn from 'babel-runtime/helpers/possibleConstructorReturn';
import _inherits from 'babel-runtime/helpers/inherits';
import React from 'react';
import PropTypes from 'prop-types';
import TableRow from './TableRow';
import TableHeader from './TableHeader';
import { measureScrollbar, debounce, warningOnce } from './utils';
import shallowequal from 'shallowequal';
import addEventListener from 'rc-util/es/Dom/addEventListener';
import ColumnManager from './ColumnManager';
import createStore from './createStore';
import classes from 'component-classes';

var Table = function (_React$Component) {
  _inherits(Table, _React$Component);

  function Table(props) {
    _classCallCheck(this, Table);

    var _this = _possibleConstructorReturn(this, (Table.__proto__ || Object.getPrototypeOf(Table)).call(this, props));

    _this.onExpanded = function (expanded, record, e, index) {
      if (e) {
        e.preventDefault();
        e.stopPropagation();
      }
      var info = _this.findExpandedRow(record);
      if (typeof info !== 'undefined' && !expanded) {
        _this.onRowDestroy(record, index);
      } else if (!info && expanded) {
        var expandedRows = _this.getExpandedRows().concat();
        expandedRows.push(_this.getRowKey(record, index));
        _this.onExpandedRowsChange(expandedRows);
      }
      _this.props.onExpand(expanded, record);
    };

    _this.onRowDestroy = function (record, rowIndex) {
      var expandedRows = _this.getExpandedRows().concat();
      var rowKey = _this.getRowKey(record, rowIndex);
      var index = -1;
      expandedRows.forEach(function (r, i) {
        if (r === rowKey) {
          index = i;
        }
      });
      if (index !== -1) {
        expandedRows.splice(index, 1);
      }
      _this.onExpandedRowsChange(expandedRows);
    };

    _this.handleWindowResize = function () {
      _this.syncFixedTableRowHeight();
      _this.setScrollPositionClassName();
    };

    _this.syncFixedTableRowHeight = function () {
      var tableRect = _this.tableNode.getBoundingClientRect();
                  if (tableRect.height !== undefined && tableRect.height <= 0) {
        return;
      }
      var prefixCls = _this.props.prefixCls;

      var headRows = _this.refs.headTable ? _this.refs.headTable.querySelectorAll('thead') : _this.refs.bodyTable.querySelectorAll('thead');
      var bodyRows = _this.refs.bodyTable.querySelectorAll('.' + prefixCls + '-row') || [];
      var fixedColumnsHeadRowsHeight = [].map.call(headRows, function (row) {
        return row.getBoundingClientRect().height || 'auto';
      });
      var fixedColumnsBodyRowsHeight = [].map.call(bodyRows, function (row) {
        return row.getBoundingClientRect().height || 'auto';
      });
      if (shallowequal(_this.state.fixedColumnsHeadRowsHeight, fixedColumnsHeadRowsHeight) && shallowequal(_this.state.fixedColumnsBodyRowsHeight, fixedColumnsBodyRowsHeight)) {
        return;
      }
      _this.setState({
        fixedColumnsHeadRowsHeight: fixedColumnsHeadRowsHeight,
        fixedColumnsBodyRowsHeight: fixedColumnsBodyRowsHeight
      });
    };

    _this.detectScrollTarget = function (e) {
      if (_this.scrollTarget !== e.currentTarget) {
        _this.scrollTarget = e.currentTarget;
      }
    };

    _this.handleBodyScroll = function (e) {
                  if (e.target !== _this.scrollTarget) {
        return;
      }
      var _this$props$scroll = _this.props.scroll,
          scroll = _this$props$scroll === undefined ? {} : _this$props$scroll;
      var _this$refs = _this.refs,
          headTable = _this$refs.headTable,
          bodyTable = _this$refs.bodyTable,
          fixedColumnsBodyLeft = _this$refs.fixedColumnsBodyLeft,
          fixedColumnsBodyRight = _this$refs.fixedColumnsBodyRight;

      if (scroll.x && e.target.scrollLeft !== _this.lastScrollLeft) {
        if (e.target === bodyTable && headTable) {
          headTable.scrollLeft = e.target.scrollLeft;
        } else if (e.target === headTable && bodyTable) {
          bodyTable.scrollLeft = e.target.scrollLeft;
        }
        _this.setScrollPositionClassName(e.target);
      }
      if (scroll.y) {
        if (fixedColumnsBodyLeft && e.target !== fixedColumnsBodyLeft) {
          fixedColumnsBodyLeft.scrollTop = e.target.scrollTop;
        }
        if (fixedColumnsBodyRight && e.target !== fixedColumnsBodyRight) {
          fixedColumnsBodyRight.scrollTop = e.target.scrollTop;
        }
        if (bodyTable && e.target !== bodyTable) {
          bodyTable.scrollTop = e.target.scrollTop;
        }
      }
            _this.lastScrollLeft = e.target.scrollLeft;
    };

    _this.handleRowHover = function (isHover, key) {
      _this.store.setState({
        currentHoverKey: isHover ? key : null
      });
    };

    var expandedRowKeys = [];
    var rows = [].concat(_toConsumableArray(props.data));
    _this.columnManager = new ColumnManager(props.columns, props.children);
    _this.store = createStore({
      currentHoverKey: null,
      expandedRowsHeight: {}
    });
    _this.setScrollPosition('left');

    if (props.defaultExpandAllRows) {
      for (var i = 0; i < rows.length; i++) {
        var row = rows[i];
        expandedRowKeys.push(_this.getRowKey(row, i));
        rows = rows.concat(row[props.childrenColumnName] || []);
      }
    } else {
      expandedRowKeys = props.expandedRowKeys || props.defaultExpandedRowKeys;
    }
    _this.state = {
      expandedRowKeys: expandedRowKeys,
      currentHoverKey: null,
      fixedColumnsHeadRowsHeight: [],
      fixedColumnsBodyRowsHeight: []
    };
    return _this;
  }

  _createClass(Table, [{
    key: 'componentDidMount',
    value: function componentDidMount() {
      if (this.columnManager.isAnyColumnsFixed()) {
        this.handleWindowResize();
        this.debouncedWindowResize = debounce(this.handleWindowResize, 150);
        this.resizeEvent = addEventListener(window, 'resize', this.debouncedWindowResize);
      }
    }
  }, {
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      if ('expandedRowKeys' in nextProps) {
        this.setState({
          expandedRowKeys: nextProps.expandedRowKeys
        });
      }
      if (nextProps.columns && nextProps.columns !== this.props.columns) {
        this.columnManager.reset(nextProps.columns);
      } else if (nextProps.children !== this.props.children) {
        this.columnManager.reset(null, nextProps.children);
      }
    }
  }, {
    key: 'componentDidUpdate',
    value: function componentDidUpdate(prevProps) {
      if (this.columnManager.isAnyColumnsFixed()) {
        this.handleWindowResize();
      }
            if (prevProps.data.length > 0 && this.props.data.length === 0 && this.hasScrollX()) {
        this.resetScrollX();
      }
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      if (this.resizeEvent) {
        this.resizeEvent.remove();
      }
      if (this.debouncedWindowResize) {
        this.debouncedWindowResize.cancel();
      }
    }
  }, {
    key: 'onExpandedRowsChange',
    value: function onExpandedRowsChange(expandedRowKeys) {
      if (!this.props.expandedRowKeys) {
        this.setState({ expandedRowKeys: expandedRowKeys });
      }
      this.props.onExpandedRowsChange(expandedRowKeys);
    }
  }, {
    key: 'getRowKey',
    value: function getRowKey(record, index) {
      var rowKey = this.props.rowKey;
      var key = typeof rowKey === 'function' ? rowKey(record, index) : record[rowKey];
      warningOnce(key !== undefined, 'Each record in table should have a unique `key` prop,' + 'or set `rowKey` to an unique primary key.');
      return key === undefined ? index : key;
    }
  }, {
    key: 'getExpandedRows',
    value: function getExpandedRows() {
      return this.props.expandedRowKeys || this.state.expandedRowKeys;
    }
  }, {
    key: 'getHeader',
    value: function getHeader(columns, fixed) {
      var _props = this.props,
          showHeader = _props.showHeader,
          expandIconAsCell = _props.expandIconAsCell,
          prefixCls = _props.prefixCls;

      var rows = this.getHeaderRows(columns);

      if (expandIconAsCell && fixed !== 'right') {
        rows[0].unshift({
          key: 'rc-table-expandIconAsCell',
          className: prefixCls + '-expand-icon-th',
          title: '',
          rowSpan: rows.length
        });
      }

      var trStyle = fixed ? this.getHeaderRowStyle(columns, rows) : null;

      return showHeader ? React.createElement(TableHeader, {
        prefixCls: prefixCls,
        rows: rows,
        rowStyle: trStyle
      }) : null;
    }
  }, {
    key: 'getHeaderRows',
    value: function getHeaderRows(columns) {
      var _this2 = this;

      var currentRow = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
      var rows = arguments[2];

      rows = rows || [];
      rows[currentRow] = rows[currentRow] || [];

      columns.forEach(function (column) {
        if (column.rowSpan && rows.length < column.rowSpan) {
          while (rows.length < column.rowSpan) {
            rows.push([]);
          }
        }
        var cell = {
          key: column.key,
          className: column.className || '',
          children: column.title
        };
        if (column.children) {
          _this2.getHeaderRows(column.children, currentRow + 1, rows);
        }
        if ('colSpan' in column) {
          cell.colSpan = column.colSpan;
        }
        if ('rowSpan' in column) {
          cell.rowSpan = column.rowSpan;
        }
        if (cell.colSpan !== 0) {
          rows[currentRow].push(cell);
        }
      });
      return rows.filter(function (row) {
        return row.length > 0;
      });
    }
  }, {
    key: 'getExpandedRow',
    value: function getExpandedRow(key, content, visible, className, fixed) {
      var _props2 = this.props,
          prefixCls = _props2.prefixCls,
          expandIconAsCell = _props2.expandIconAsCell;

      var colCount = void 0;
      if (fixed === 'left') {
        colCount = this.columnManager.leftLeafColumns().length;
      } else if (fixed === 'right') {
        colCount = this.columnManager.rightLeafColumns().length;
      } else {
        colCount = this.columnManager.leafColumns().length;
      }
      var columns = [{
        key: 'extra-row',
        render: function render() {
          return {
            props: {
              colSpan: colCount
            },
            children: fixed !== 'right' ? content : '&nbsp;'
          };
        }
      }];
      if (expandIconAsCell && fixed !== 'right') {
        columns.unshift({
          key: 'expand-icon-placeholder',
          render: function render() {
            return null;
          }
        });
      }
      return React.createElement(TableRow, {
        columns: columns,
        visible: visible,
        className: className,
        key: key + '-extra-row',
        rowKey: key + '-extra-row',
        prefixCls: prefixCls + '-expanded-row',
        indent: 1,
        expandable: false,
        store: this.store,
        expandedRow: true,
        fixed: !!fixed
      });
    }
  }, {
    key: 'getRowsByData',
    value: function getRowsByData(data, visible, indent, columns, fixed) {
      var props = this.props;
      var childrenColumnName = props.childrenColumnName;
      var expandedRowRender = props.expandedRowRender;
      var expandRowByClick = props.expandRowByClick;
      var fixedColumnsBodyRowsHeight = this.state.fixedColumnsBodyRowsHeight;

      var rst = [];
      var rowClassName = props.rowClassName;
      var rowRef = props.rowRef;
      var expandedRowClassName = props.expandedRowClassName;
      var needIndentSpaced = props.data.some(function (record) {
        return record[childrenColumnName];
      });
      var onRowClick = props.onRowClick;
      var onRowDoubleClick = props.onRowDoubleClick;

      var expandIconAsCell = fixed !== 'right' ? props.expandIconAsCell : false;
      var expandIconColumnIndex = fixed !== 'right' ? props.expandIconColumnIndex : -1;

      for (var i = 0; i < data.length; i++) {
        var record = data[i];
        var key = this.getRowKey(record, i);
        var childrenColumn = record[childrenColumnName];
        var isRowExpanded = this.isRowExpanded(record, i);
        var expandedRowContent = void 0;
        if (expandedRowRender && isRowExpanded) {
          expandedRowContent = expandedRowRender(record, i, indent);
        }
        var className = rowClassName(record, i, indent);

        var onHoverProps = {};
        if (this.columnManager.isAnyColumnsFixed()) {
          onHoverProps.onHover = this.handleRowHover;
        }

        var height = fixed && fixedColumnsBodyRowsHeight[i] ? fixedColumnsBodyRowsHeight[i] : null;

        var leafColumns = void 0;
        if (fixed === 'left') {
          leafColumns = this.columnManager.leftLeafColumns();
        } else if (fixed === 'right') {
          leafColumns = this.columnManager.rightLeafColumns();
        } else {
          leafColumns = this.columnManager.leafColumns();
        }

        rst.push(React.createElement(TableRow, _extends({
          indent: indent,
          indentSize: props.indentSize,
          needIndentSpaced: needIndentSpaced,
          className: className,
          record: record,
          expandIconAsCell: expandIconAsCell,
          onDestroy: this.onRowDestroy,
          index: i,
          visible: visible,
          expandRowByClick: expandRowByClick,
          onExpand: this.onExpanded,
          expandable: childrenColumn || expandedRowRender,
          expanded: isRowExpanded,
          prefixCls: props.prefixCls + '-row',
          childrenColumnName: childrenColumnName,
          columns: leafColumns,
          expandIconColumnIndex: expandIconColumnIndex,
          onRowClick: onRowClick,
          onRowDoubleClick: onRowDoubleClick,
          height: height
        }, onHoverProps, {
          key: key,
          hoverKey: key,
          ref: rowRef(record, i, indent),
          store: this.store
        })));

        var subVisible = visible && isRowExpanded;

        if (expandedRowContent && isRowExpanded) {
          rst.push(this.getExpandedRow(key, expandedRowContent, subVisible, expandedRowClassName(record, i, indent), fixed));
        }
        if (childrenColumn) {
          rst = rst.concat(this.getRowsByData(childrenColumn, subVisible, indent + 1, columns, fixed));
        }
      }
      return rst;
    }
  }, {
    key: 'getRows',
    value: function getRows(columns, fixed) {
      return this.getRowsByData(this.props.data, true, 0, columns, fixed);
    }
  }, {
    key: 'getColGroup',
    value: function getColGroup(columns, fixed) {
      var cols = [];
      if (this.props.expandIconAsCell && fixed !== 'right') {
        cols.push(React.createElement('col', {
          className: this.props.prefixCls + '-expand-icon-col',
          key: 'rc-table-expand-icon-col'
        }));
      }
      var leafColumns = void 0;
      if (fixed === 'left') {
        leafColumns = this.columnManager.leftLeafColumns();
      } else if (fixed === 'right') {
        leafColumns = this.columnManager.rightLeafColumns();
      } else {
        leafColumns = this.columnManager.leafColumns();
      }
      cols = cols.concat(leafColumns.map(function (c) {
        return React.createElement('col', { key: c.key, style: { width: c.width, minWidth: c.width } });
      }));
      return React.createElement(
        'colgroup',
        null,
        cols
      );
    }
  }, {
    key: 'getLeftFixedTable',
    value: function getLeftFixedTable() {
      return this.getTable({
        columns: this.columnManager.leftColumns(),
        fixed: 'left'
      });
    }
  }, {
    key: 'getRightFixedTable',
    value: function getRightFixedTable() {
      return this.getTable({
        columns: this.columnManager.rightColumns(),
        fixed: 'right'
      });
    }
  }, {
    key: 'getTable',
    value: function getTable() {
      var _this3 = this;

      var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var columns = options.columns,
          fixed = options.fixed;
      var _props3 = this.props,
          prefixCls = _props3.prefixCls,
          _props3$scroll = _props3.scroll,
          scroll = _props3$scroll === undefined ? {} : _props3$scroll,
          getBodyWrapper = _props3.getBodyWrapper;
      var useFixedHeader = this.props.useFixedHeader;

      var bodyStyle = _extends({}, this.props.bodyStyle);
      var headStyle = {};

      var tableClassName = '';
      if (scroll.x || fixed) {
        tableClassName = prefixCls + '-fixed';
        bodyStyle.overflowX = bodyStyle.overflowX || 'auto';
      }

      var innerBodyStyle = {};
      if (scroll.y) {
                        if (fixed) {
          innerBodyStyle.maxHeight = bodyStyle.maxHeight || scroll.y;
          innerBodyStyle.overflowY = bodyStyle.overflowY || 'scroll';
        } else {
          bodyStyle.maxHeight = bodyStyle.maxHeight || scroll.y;
        }
        bodyStyle.overflowY = bodyStyle.overflowY || 'scroll';
        useFixedHeader = true;

                var scrollbarWidth = measureScrollbar();
        if (scrollbarWidth > 0) {
          (fixed ? bodyStyle : headStyle).marginBottom = '-' + scrollbarWidth + 'px';
          (fixed ? bodyStyle : headStyle).paddingBottom = '0px';
        }
      }

      var renderTable = function renderTable() {
        var hasHead = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
        var hasBody = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

        var tableStyle = {};
        if (!fixed && scroll.x) {
                    if (scroll.x === true) {
            tableStyle.tableLayout = 'fixed';
          } else {
            tableStyle.width = scroll.x;
          }
        }
        var tableBody = hasBody ? getBodyWrapper(React.createElement(
          'tbody',
          { className: prefixCls + '-tbody' },
          _this3.getRows(columns, fixed)
        )) : null;
        return React.createElement(
          'table',
          { className: tableClassName, style: tableStyle, key: 'table' },
          _this3.getColGroup(columns, fixed),
          hasHead ? _this3.getHeader(columns, fixed) : null,
          tableBody
        );
      };

      var headTable = void 0;

      if (useFixedHeader) {
        headTable = React.createElement(
          'div',
          {
            key: 'headTable',
            className: prefixCls + '-header',
            ref: fixed ? null : 'headTable',
            style: headStyle,
            onMouseOver: this.detectScrollTarget,
            onTouchStart: this.detectScrollTarget,
            onScroll: this.handleBodyScroll
          },
          renderTable(true, false)
        );
      }

      var bodyTable = React.createElement(
        'div',
        {
          key: 'bodyTable',
          className: prefixCls + '-body',
          style: bodyStyle,
          ref: 'bodyTable',
          onMouseOver: this.detectScrollTarget,
          onTouchStart: this.detectScrollTarget,
          onScroll: this.handleBodyScroll
        },
        renderTable(!useFixedHeader)
      );

      if (fixed && columns.length) {
        var refName = void 0;
        if (columns[0].fixed === 'left' || columns[0].fixed === true) {
          refName = 'fixedColumnsBodyLeft';
        } else if (columns[0].fixed === 'right') {
          refName = 'fixedColumnsBodyRight';
        }
        delete bodyStyle.overflowX;
        delete bodyStyle.overflowY;
        bodyTable = React.createElement(
          'div',
          {
            key: 'bodyTable',
            className: prefixCls + '-body-outer',
            style: _extends({}, bodyStyle)
          },
          React.createElement(
            'div',
            {
              className: prefixCls + '-body-inner',
              style: innerBodyStyle,
              ref: refName,
              onMouseOver: this.detectScrollTarget,
              onTouchStart: this.detectScrollTarget,
              onScroll: this.handleBodyScroll
            },
            renderTable(!useFixedHeader)
          )
        );
      }
      return [headTable, bodyTable];
    }
  }, {
    key: 'getTitle',
    value: function getTitle() {
      var _props4 = this.props,
          title = _props4.title,
          prefixCls = _props4.prefixCls;

      return title ? React.createElement(
        'div',
        { className: prefixCls + '-title', key: 'title' },
        title(this.props.data)
      ) : null;
    }
  }, {
    key: 'getFooter',
    value: function getFooter() {
      var _props5 = this.props,
          footer = _props5.footer,
          prefixCls = _props5.prefixCls;

      return footer ? React.createElement(
        'div',
        { className: prefixCls + '-footer', key: 'footer' },
        footer(this.props.data)
      ) : null;
    }
  }, {
    key: 'getEmptyText',
    value: function getEmptyText() {
      var _props6 = this.props,
          emptyText = _props6.emptyText,
          prefixCls = _props6.prefixCls,
          data = _props6.data;

      return !data.length ? React.createElement(
        'div',
        { className: prefixCls + '-placeholder', key: 'emptyText' },
        typeof emptyText === 'function' ? emptyText() : emptyText
      ) : null;
    }
  }, {
    key: 'getHeaderRowStyle',
    value: function getHeaderRowStyle(columns, rows) {
      var fixedColumnsHeadRowsHeight = this.state.fixedColumnsHeadRowsHeight;

      var headerHeight = fixedColumnsHeadRowsHeight[0];
      if (headerHeight && columns) {
        if (headerHeight === 'auto') {
          return { height: 'auto' };
        }
        return { height: headerHeight / rows.length };
      }
      return null;
    }
  }, {
    key: 'setScrollPosition',
    value: function setScrollPosition(position) {
      this.scrollPosition = position;
      if (this.tableNode) {
        var prefixCls = this.props.prefixCls;

        if (position === 'both') {
          classes(this.tableNode).remove(new RegExp('^' + prefixCls + '-scroll-position-.+$')).add(prefixCls + '-scroll-position-left').add(prefixCls + '-scroll-position-right');
        } else {
          classes(this.tableNode).remove(new RegExp('^' + prefixCls + '-scroll-position-.+$')).add(prefixCls + '-scroll-position-' + position);
        }
      }
    }
  }, {
    key: 'setScrollPositionClassName',
    value: function setScrollPositionClassName(target) {
      var node = target || this.refs.bodyTable;
      var scrollToLeft = node.scrollLeft === 0;
      var scrollToRight = node.scrollLeft + 1 >= node.children[0].getBoundingClientRect().width - node.getBoundingClientRect().width;
      if (scrollToLeft && scrollToRight) {
        this.setScrollPosition('both');
      } else if (scrollToLeft) {
        this.setScrollPosition('left');
      } else if (scrollToRight) {
        this.setScrollPosition('right');
      } else if (this.scrollPosition !== 'middle') {
        this.setScrollPosition('middle');
      }
    }
  }, {
    key: 'resetScrollX',
    value: function resetScrollX() {
      if (this.refs.headTable) {
        this.refs.headTable.scrollLeft = 0;
      }
      if (this.refs.bodyTable) {
        this.refs.bodyTable.scrollLeft = 0;
      }
    }
  }, {
    key: 'findExpandedRow',
    value: function findExpandedRow(record, index) {
      var _this4 = this;

      var rows = this.getExpandedRows().filter(function (i) {
        return i === _this4.getRowKey(record, index);
      });
      return rows[0];
    }
  }, {
    key: 'isRowExpanded',
    value: function isRowExpanded(record, index) {
      return typeof this.findExpandedRow(record, index) !== 'undefined';
    }
  }, {
    key: 'hasScrollX',
    value: function hasScrollX() {
      var _props$scroll = this.props.scroll,
          scroll = _props$scroll === undefined ? {} : _props$scroll;

      return 'x' in scroll;
    }
  }, {
    key: 'render',
    value: function render() {
      var _this5 = this;

      var props = this.props;
      var prefixCls = props.prefixCls;

      var className = props.prefixCls;
      if (props.className) {
        className += ' ' + props.className;
      }
      if (props.useFixedHeader || props.scroll && props.scroll.y) {
        className += ' ' + prefixCls + '-fixed-header';
      }
      if (this.scrollPosition === 'both') {
        className += ' ' + prefixCls + '-scroll-position-left ' + prefixCls + '-scroll-position-right';
      } else {
        className += ' ' + prefixCls + '-scroll-position-' + this.scrollPosition;
      }

      var isTableScroll = this.columnManager.isAnyColumnsFixed() || props.scroll.x || props.scroll.y;

      var content = [this.getTable({ columns: this.columnManager.groupedColumns() }), this.getEmptyText(), this.getFooter()];

      var scrollTable = isTableScroll ? React.createElement(
        'div',
        { className: prefixCls + '-scroll' },
        content
      ) : content;

      return React.createElement(
        'div',
        { ref: function ref(node) {
            return _this5.tableNode = node;
          }, className: className, style: props.style },
        this.getTitle(),
        React.createElement(
          'div',
          { className: prefixCls + '-content' },
          scrollTable,
          this.columnManager.isAnyColumnsLeftFixed() && React.createElement(
            'div',
            { className: prefixCls + '-fixed-left' },
            this.getLeftFixedTable()
          ),
          this.columnManager.isAnyColumnsRightFixed() && React.createElement(
            'div',
            { className: prefixCls + '-fixed-right' },
            this.getRightFixedTable()
          )
        )
      );
    }
  }]);

  return Table;
}(React.Component);

Table.propTypes = {
  data: PropTypes.array,
  expandIconAsCell: PropTypes.bool,
  defaultExpandAllRows: PropTypes.bool,
  expandedRowKeys: PropTypes.array,
  defaultExpandedRowKeys: PropTypes.array,
  useFixedHeader: PropTypes.bool,
  columns: PropTypes.array,
  prefixCls: PropTypes.string,
  bodyStyle: PropTypes.object,
  style: PropTypes.object,
  rowKey: PropTypes.oneOfType([PropTypes.string, PropTypes.func]),
  rowClassName: PropTypes.func,
  expandedRowClassName: PropTypes.func,
  childrenColumnName: PropTypes.string,
  onExpand: PropTypes.func,
  onExpandedRowsChange: PropTypes.func,
  indentSize: PropTypes.number,
  onRowClick: PropTypes.func,
  onRowDoubleClick: PropTypes.func,
  expandIconColumnIndex: PropTypes.number,
  showHeader: PropTypes.bool,
  title: PropTypes.func,
  footer: PropTypes.func,
  emptyText: PropTypes.oneOfType([PropTypes.node, PropTypes.func]),
  scroll: PropTypes.object,
  rowRef: PropTypes.func,
  getBodyWrapper: PropTypes.func,
  children: PropTypes.node
};
Table.defaultProps = {
  data: [],
  useFixedHeader: false,
  expandIconAsCell: false,
  defaultExpandAllRows: false,
  defaultExpandedRowKeys: [],
  rowKey: 'key',
  rowClassName: function rowClassName() {
    return '';
  },
  expandedRowClassName: function expandedRowClassName() {
    return '';
  },
  onExpand: function onExpand() {},
  onExpandedRowsChange: function onExpandedRowsChange() {},
  onRowClick: function onRowClick() {},
  onRowDoubleClick: function onRowDoubleClick() {},

  prefixCls: 'rc-table',
  bodyStyle: {},
  style: {},
  childrenColumnName: 'children',
  indentSize: 15,
  expandIconColumnIndex: 0,
  showHeader: true,
  scroll: {},
  rowRef: function rowRef() {
    return null;
  },
  getBodyWrapper: function getBodyWrapper(body) {
    return body;
  },
  emptyText: function emptyText() {
    return 'No Data';
  }
};
export default Table;