import _classCallCheck from 'babel-runtime/helpers/classCallCheck';
import _createClass from 'babel-runtime/helpers/createClass';
import _possibleConstructorReturn from 'babel-runtime/helpers/possibleConstructorReturn';
import _inherits from 'babel-runtime/helpers/inherits';
import React from 'react';
import PropTypes from 'prop-types';
import TableCell from './TableCell';
import ExpandIcon from './ExpandIcon';

var TableRow = function (_React$Component) {
  _inherits(TableRow, _React$Component);

  function TableRow() {
    var _ref;

    var _temp, _this, _ret;

    _classCallCheck(this, TableRow);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = TableRow.__proto__ || Object.getPrototypeOf(TableRow)).call.apply(_ref, [this].concat(args))), _this), _this.state = {
      hovered: false,
      height: null
    }, _this.onRowClick = function (event) {
      var _this$props = _this.props,
          record = _this$props.record,
          index = _this$props.index,
          onRowClick = _this$props.onRowClick,
          expandable = _this$props.expandable,
          expandRowByClick = _this$props.expandRowByClick,
          expanded = _this$props.expanded,
          onExpand = _this$props.onExpand;

      if (expandable && expandRowByClick) {
        onExpand(!expanded, record, event, index);
      }
      onRowClick(record, index, event);
    }, _this.onRowDoubleClick = function (event) {
      var _this$props2 = _this.props,
          record = _this$props2.record,
          index = _this$props2.index,
          onRowDoubleClick = _this$props2.onRowDoubleClick;

      onRowDoubleClick(record, index, event);
    }, _this.onMouseEnter = function () {
      var _this$props3 = _this.props,
          onHover = _this$props3.onHover,
          hoverKey = _this$props3.hoverKey;

      onHover(true, hoverKey);
    }, _this.onMouseLeave = function () {
      var _this$props4 = _this.props,
          onHover = _this$props4.onHover,
          hoverKey = _this$props4.hoverKey;

      onHover(false, hoverKey);
    }, _temp), _possibleConstructorReturn(_this, _ret);
  }

  _createClass(TableRow, [{
    key: 'componentDidMount',
    value: function componentDidMount() {
      var _this2 = this;

      var store = this.props.store;

      this.pushHeight();
      this.pullHeight();
      this.unsubscribe = store.subscribe(function () {
        _this2.setHover();
        _this2.pullHeight();
      });
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      var _props = this.props,
          record = _props.record,
          onDestroy = _props.onDestroy,
          index = _props.index;

      onDestroy(record, index);
      if (this.unsubscribe) {
        this.unsubscribe();
      }
    }
  }, {
    key: 'setHover',
    value: function setHover() {
      var _props2 = this.props,
          store = _props2.store,
          hoverKey = _props2.hoverKey;

      var _store$getState = store.getState(),
          currentHoverKey = _store$getState.currentHoverKey;

      if (currentHoverKey === hoverKey) {
        this.setState({ hovered: true });
      } else if (this.state.hovered === true) {
        this.setState({ hovered: false });
      }
    }
  }, {
    key: 'pullHeight',
    value: function pullHeight() {
      var _props3 = this.props,
          store = _props3.store,
          expandedRow = _props3.expandedRow,
          fixed = _props3.fixed,
          rowKey = _props3.rowKey;

      var _store$getState2 = store.getState(),
          expandedRowsHeight = _store$getState2.expandedRowsHeight;

      if (expandedRow && fixed && expandedRowsHeight[rowKey]) {
        this.setState({ height: expandedRowsHeight[rowKey] });
      }
    }
  }, {
    key: 'pushHeight',
    value: function pushHeight() {
      var _props4 = this.props,
          store = _props4.store,
          expandedRow = _props4.expandedRow,
          fixed = _props4.fixed,
          rowKey = _props4.rowKey;

      if (expandedRow && !fixed) {
        var _store$getState3 = store.getState(),
            expandedRowsHeight = _store$getState3.expandedRowsHeight;

        var height = this.trRef.getBoundingClientRect().height;
        expandedRowsHeight[rowKey] = height;
        store.setState({ expandedRowsHeight: expandedRowsHeight });
      }
    }
  }, {
    key: 'render',
    value: function render() {
      var _this3 = this;

      var _props5 = this.props,
          prefixCls = _props5.prefixCls,
          columns = _props5.columns,
          record = _props5.record,
          visible = _props5.visible,
          index = _props5.index,
          expandIconColumnIndex = _props5.expandIconColumnIndex,
          expandIconAsCell = _props5.expandIconAsCell,
          expanded = _props5.expanded,
          expandRowByClick = _props5.expandRowByClick,
          expandable = _props5.expandable,
          onExpand = _props5.onExpand,
          needIndentSpaced = _props5.needIndentSpaced,
          indent = _props5.indent,
          indentSize = _props5.indentSize;
      var className = this.props.className;


      if (this.state.hovered) {
        className += ' ' + prefixCls + '-hover';
      }

      var cells = [];

      var expandIcon = React.createElement(ExpandIcon, {
        expandable: expandable,
        prefixCls: prefixCls,
        onExpand: onExpand,
        needIndentSpaced: needIndentSpaced,
        expanded: expanded,
        record: record
      });

      for (var i = 0; i < columns.length; i++) {
        if (expandIconAsCell && i === 0) {
          cells.push(React.createElement(
            'td',
            {
              className: prefixCls + '-expand-icon-cell',
              key: 'rc-table-expand-icon-cell'
            },
            expandIcon
          ));
        }
        var isColumnHaveExpandIcon = expandIconAsCell || expandRowByClick ? false : i === expandIconColumnIndex;
        cells.push(React.createElement(TableCell, {
          prefixCls: prefixCls,
          record: record,
          indentSize: indentSize,
          indent: indent,
          index: index,
          column: columns[i],
          key: columns[i].key,
          expandIcon: isColumnHaveExpandIcon ? expandIcon : null
        }));
      }
      var height = this.props.height || this.state.height;
      var style = { height: height };
      if (!visible) {
        style.display = 'none';
      }

      return React.createElement(
        'tr',
        {
          ref: function ref(node) {
            return _this3.trRef = node;
          },
          onClick: this.onRowClick,
          onDoubleClick: this.onRowDoubleClick,
          onMouseEnter: this.onMouseEnter,
          onMouseLeave: this.onMouseLeave,
          className: prefixCls + ' ' + className + ' ' + prefixCls + '-level-' + indent,
          style: style
        },
        cells
      );
    }
  }]);

  return TableRow;
}(React.Component);

TableRow.propTypes = {
  onDestroy: PropTypes.func,
  onRowClick: PropTypes.func,
  onRowDoubleClick: PropTypes.func,
  record: PropTypes.object,
  prefixCls: PropTypes.string,
  expandIconColumnIndex: PropTypes.number,
  onHover: PropTypes.func,
  columns: PropTypes.array,
  height: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
  visible: PropTypes.bool,
  index: PropTypes.number,
  hoverKey: PropTypes.any,
  expanded: PropTypes.bool,
  expandable: PropTypes.any,
  onExpand: PropTypes.func,
  needIndentSpaced: PropTypes.bool,
  className: PropTypes.string,
  indent: PropTypes.number,
  indentSize: PropTypes.number,
  expandIconAsCell: PropTypes.bool,
  expandRowByClick: PropTypes.bool,
  store: PropTypes.object.isRequired,
  expandedRow: PropTypes.bool,
  fixed: PropTypes.bool,
  rowKey: PropTypes.string
};
TableRow.defaultProps = {
  onRowClick: function onRowClick() {},
  onRowDoubleClick: function onRowDoubleClick() {},
  onDestroy: function onDestroy() {},

  expandIconColumnIndex: 0,
  expandRowByClick: false,
  onHover: function onHover() {}
};
export default TableRow;