import _defineProperty from 'babel-runtime/helpers/defineProperty';
import React from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import { measureScrollbar } from './utils';
import BaseTable from './BaseTable';

export default function HeadTable(props, _ref) {
  var table = _ref.table;
  var _table$props = table.props,
      prefixCls = _table$props.prefixCls,
      scroll = _table$props.scroll,
      showHeader = _table$props.showHeader;
  var columns = props.columns,
      fixed = props.fixed,
      tableClassName = props.tableClassName,
      handleBodyScrollLeft = props.handleBodyScrollLeft,
      expander = props.expander;
  var saveRef = table.saveRef;
  var useFixedHeader = table.props.useFixedHeader;

  var headStyle = {};
  var scrollbarWidth = measureScrollbar({ direction: 'vertical' });

  if (scroll.y) {
    useFixedHeader = true;
    // https://github.com/ant-design/ant-design/issues/17051
    var scrollbarWidthOfHeader = measureScrollbar({ direction: 'horizontal', prefixCls: prefixCls });
    // Add negative margin bottom for scroll bar overflow bug
    if (scrollbarWidthOfHeader > 0 && !fixed) {
      headStyle.marginBottom = '-' + scrollbarWidthOfHeader + 'px';
      headStyle.paddingBottom = '0px';
      // https://github.com/ant-design/ant-design/issues/17051
      headStyle.overflowX = 'scroll';
      headStyle.overflowY = '' + (scrollbarWidth === 0 ? 'hidden' : 'scroll');
    }
  }

  if (!useFixedHeader || !showHeader) {
    return null;
  }

  return React.createElement(
    'div',
    {
      key: 'headTable',
      ref: fixed ? null : saveRef('headTable'),
      className: classNames(prefixCls + '-header', _defineProperty({}, prefixCls + '-hide-scrollbar', scrollbarWidth > 0)),
      style: headStyle,
      onScroll: handleBodyScrollLeft
    },
    React.createElement(BaseTable, {
      tableClassName: tableClassName,
      hasHead: true,
      hasBody: false,
      fixed: fixed,
      columns: columns,
      expander: expander
    })
  );
}

HeadTable.propTypes = {
  fixed: PropTypes.oneOfType([PropTypes.string, PropTypes.bool]),
  columns: PropTypes.array.isRequired,
  tableClassName: PropTypes.string.isRequired,
  handleBodyScrollLeft: PropTypes.func.isRequired,
  expander: PropTypes.object.isRequired
};

HeadTable.contextTypes = {
  table: PropTypes.any
};