import * as React from 'react';
import Cell from '../Cell';
import TableContext from '../context/TableContext';

function ExpandedRow(_ref) {
  var prefixCls = _ref.prefixCls,
      children = _ref.children,
      Component = _ref.component,
      cellComponent = _ref.cellComponent,
      fixHeader = _ref.fixHeader,
      fixColumn = _ref.fixColumn,
      className = _ref.className,
      expanded = _ref.expanded,
      componentWidth = _ref.componentWidth,
      colSpan = _ref.colSpan;

  var _React$useContext = React.useContext(TableContext),
      scrollbarSize = _React$useContext.scrollbarSize; // Cache render node


  return React.useMemo(function () {
    var contentNode = children;

    if (fixColumn) {
      contentNode = React.createElement("div", {
        style: {
          width: componentWidth - (fixHeader ? scrollbarSize : 0),
          position: 'sticky',
          left: 0,
          overflow: 'hidden'
        },
        className: "".concat(prefixCls, "-expanded-row-fixed")
      }, contentNode);
    }

    return React.createElement(Component, {
      className: className,
      style: {
        display: expanded ? null : 'none'
      }
    }, React.createElement(Cell, {
      component: cellComponent,
      prefixCls: prefixCls,
      colSpan: colSpan
    }, contentNode));
  }, [children, Component, fixHeader, fixColumn, className, expanded, componentWidth, colSpan, scrollbarSize]);
}

export default ExpandedRow;