import * as React from 'react';
import { DataIndex, ColumnType, CustomizeComponent, DefaultRecordType, AlignType } from '../interface';
export interface CellProps<RecordType extends DefaultRecordType> {
    prefixCls?: string;
    className?: string;
    record?: RecordType;
    /** `record` index. Not `column` index. */
    index?: number;
    dataIndex?: DataIndex;
    render?: ColumnType<RecordType>['render'];
    component?: CustomizeComponent;
    children?: React.ReactNode;
    colSpan?: number;
    rowSpan?: number;
    ellipsis?: boolean;
    align?: AlignType;
    fixLeft?: number | false;
    fixRight?: number | false;
    lastFixLeft?: boolean;
    firstFixRight?: boolean;
    /** @private Used for `expandable` with nest tree */
    appendNode?: React.ReactNode;
    additionalProps?: React.HTMLAttributes<HTMLElement>;
}
declare const MemoCell: React.MemoExoticComponent<React.ForwardRefExoticComponent<CellProps<Record<string, any>> & React.RefAttributes<any>>>;
export default MemoCell;
