import * as React from 'react';
import type { AnimatedConfig, EditableConfig, OnTabScroll, RenderTabBar, TabBarExtraContent, TabPosition, TabsLocale } from '../interface';
export interface TabNavListProps {
    id: string;
    tabPosition: TabPosition;
    activeKey: string;
    rtl: boolean;
    animated?: AnimatedConfig;
    extra?: TabBarExtraContent;
    editable?: EditableConfig;
    moreIcon?: React.ReactNode;
    moreTransitionName?: string;
    mobile: boolean;
    tabBarGutter?: number;
    renderTabBar?: RenderTabBar;
    className?: string;
    style?: React.CSSProperties;
    locale?: TabsLocale;
    onTabClick: (activeKey: string, e: React.MouseEvent | React.KeyboardEvent) => void;
    onTabScroll?: OnTabScroll;
    children?: (node: React.ReactElement) => React.ReactElement;
    getPopupContainer?: (node: HTMLElement) => HTMLElement;
    popupClassName?: string;
}
declare const _default: React.ForwardRefExoticComponent<TabNavListProps & React.RefAttributes<HTMLDivElement>>;
export default _default;
