import _defineProperty from 'babel-runtime/helpers/defineProperty';
import React from 'react';
import PropTypes from 'prop-types';
import createReactClass from 'create-react-class';
import classnames from 'classnames';

var TabPane = createReactClass({
  displayName: 'TabPane',
  propTypes: {
    className: PropTypes.string,
    active: PropTypes.bool,
    style: PropTypes.any,
    destroyInactiveTabPane: PropTypes.bool,
    forceRender: PropTypes.bool,
    placeholder: PropTypes.node
  },
  getDefaultProps: function getDefaultProps() {
    return { placeholder: null };
  },
  render: function render() {
    var _classnames;

    var props = this.props;
    var className = props.className,
        destroyInactiveTabPane = props.destroyInactiveTabPane,
        active = props.active,
        forceRender = props.forceRender;

    this._isActived = this._isActived || active;
    var prefixCls = props.rootPrefixCls + '-tabpane';
    var cls = classnames((_classnames = {}, _defineProperty(_classnames, prefixCls, 1), _defineProperty(_classnames, prefixCls + '-inactive', !active), _defineProperty(_classnames, prefixCls + '-active', active), _defineProperty(_classnames, className, className), _classnames));
    var isRender = destroyInactiveTabPane ? active : this._isActived;
    return React.createElement(
      'div',
      {
        style: props.style,
        role: 'tabpanel',
        'aria-hidden': props.active ? 'false' : 'true',
        className: cls
      },
      isRender || forceRender ? props.children : props.placeholder
    );
  }
});

export default TabPane;