import _defineProperty from 'babel-runtime/helpers/defineProperty';
import _extends from 'babel-runtime/helpers/extends';
import React from 'react';
import classnames from 'classnames';
import warning from 'warning';

var tabBarExtraContentStyle = {
  float: 'right'
};

export default {
  getDefaultProps: function getDefaultProps() {
    return {
      styles: {}
    };
  },
  onTabClick: function onTabClick(key) {
    this.props.onTabClick(key);
  },
  getTabs: function getTabs() {
    var _this = this;

    var props = this.props;
    var children = props.panels;
    var activeKey = props.activeKey;
    var rst = [];
    var prefixCls = props.prefixCls;

    React.Children.forEach(children, function (child) {
      if (!child) {
        return;
      }
      var key = child.key;
      var cls = activeKey === key ? prefixCls + '-tab-active' : '';
      cls += ' ' + prefixCls + '-tab';
      var events = {};
      if (child.props.disabled) {
        cls += ' ' + prefixCls + '-tab-disabled';
      } else {
        events = {
          onClick: _this.onTabClick.bind(_this, key)
        };
      }
      var ref = {};
      if (activeKey === key) {
        ref.ref = 'activeTab';
      }
      warning('tab' in child.props, 'There must be `tab` property on children of Tabs.');
      rst.push(React.createElement(
        'div',
        _extends({
          role: 'tab',
          'aria-disabled': child.props.disabled ? 'true' : 'false',
          'aria-selected': activeKey === key ? 'true' : 'false'
        }, events, {
          className: cls,
          key: key
        }, ref),
        child.props.tab
      ));
    });

    return rst;
  },
  getRootNode: function getRootNode(contents) {
    var _classnames;

    var _props = this.props,
        prefixCls = _props.prefixCls,
        onKeyDown = _props.onKeyDown,
        className = _props.className,
        extraContent = _props.extraContent,
        style = _props.style;

    var cls = classnames((_classnames = {}, _defineProperty(_classnames, prefixCls + '-bar', 1), _defineProperty(_classnames, className, !!className), _classnames));
    return React.createElement(
      'div',
      {
        role: 'tablist',
        className: cls,
        tabIndex: '0',
        ref: 'root',
        onKeyDown: onKeyDown,
        style: style
      },
      extraContent ? React.createElement(
        'div',
        {
          style: tabBarExtraContentStyle,
          key: 'extra'
        },
        extraContent
      ) : null,
      contents
    );
  }
};