'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _defineProperty2 = require('babel-runtime/helpers/defineProperty');

var _defineProperty3 = _interopRequireDefault(_defineProperty2);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _createReactClass = require('create-react-class');

var _createReactClass2 = _interopRequireDefault(_createReactClass);

var _classnames2 = require('classnames');

var _classnames3 = _interopRequireDefault(_classnames2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var TabPane = (0, _createReactClass2['default'])({
  displayName: 'TabPane',
  propTypes: {
    className: _propTypes2['default'].string,
    active: _propTypes2['default'].bool,
    style: _propTypes2['default'].any,
    destroyInactiveTabPane: _propTypes2['default'].bool,
    forceRender: _propTypes2['default'].bool,
    placeholder: _propTypes2['default'].node
  },
  getDefaultProps: function getDefaultProps() {
    return { placeholder: null };
  },
  render: function render() {
    var _classnames;

    var props = this.props;
    var className = props.className,
        destroyInactiveTabPane = props.destroyInactiveTabPane,
        active = props.active,
        forceRender = props.forceRender;

    this._isActived = this._isActived || active;
    var prefixCls = props.rootPrefixCls + '-tabpane';
    var cls = (0, _classnames3['default'])((_classnames = {}, (0, _defineProperty3['default'])(_classnames, prefixCls, 1), (0, _defineProperty3['default'])(_classnames, prefixCls + '-inactive', !active), (0, _defineProperty3['default'])(_classnames, prefixCls + '-active', active), (0, _defineProperty3['default'])(_classnames, className, className), _classnames));
    var isRender = destroyInactiveTabPane ? active : this._isActived;
    return _react2['default'].createElement(
      'div',
      {
        style: props.style,
        role: 'tabpanel',
        'aria-hidden': props.active ? 'false' : 'true',
        className: cls
      },
      isRender || forceRender ? props.children : props.placeholder
    );
  }
});

exports['default'] = TabPane;
module.exports = exports['default'];