'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _defineProperty2 = require('babel-runtime/helpers/defineProperty');

var _defineProperty3 = _interopRequireDefault(_defineProperty2);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _KeyCode = require('./KeyCode');

var _KeyCode2 = _interopRequireDefault(_KeyCode);

var _TabPane = require('./TabPane');

var _TabPane2 = _interopRequireDefault(_TabPane);

var _classnames2 = require('classnames');

var _classnames3 = _interopRequireDefault(_classnames2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function noop() {}

function getDefaultActiveKey(props) {
  var activeKey = void 0;
  _react2['default'].Children.forEach(props.children, function (child) {
    if (child && !activeKey && !child.props.disabled) {
      activeKey = child.key;
    }
  });
  return activeKey;
}

var Tabs = function (_React$Component) {
  (0, _inherits3['default'])(Tabs, _React$Component);

  function Tabs(props) {
    (0, _classCallCheck3['default'])(this, Tabs);

    var _this = (0, _possibleConstructorReturn3['default'])(this, (Tabs.__proto__ || Object.getPrototypeOf(Tabs)).call(this, props));

    _this.render = _this.render.bind(_this);
    _this.componentWillReceiveProps = _this.componentWillReceiveProps.bind(_this);
    _this.onTabClick = _this.onTabClick.bind(_this);
    _this.onNavKeyDown = _this.onNavKeyDown.bind(_this);
    _this.setActiveKey = _this.setActiveKey.bind(_this);
    _this.getNextActiveKey = _this.getNextActiveKey.bind(_this);
    _this.onTabClick = _this.onTabClick.bind(_this);
    _this.onTabClick = _this.onTabClick.bind(_this);

    var activeKey = void 0;
    if ('activeKey' in props) {
      activeKey = props.activeKey;
    } else if ('defaultActiveKey' in props) {
      activeKey = props.defaultActiveKey;
    } else {
      activeKey = getDefaultActiveKey(props);
    }

    _this.state = {
      activeKey: activeKey
    };
    return _this;
  }

  (0, _createClass3['default'])(Tabs, [{
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      if ('activeKey' in nextProps) {
        this.setState({
          activeKey: nextProps.activeKey
        });
      }
    }
  }, {
    key: 'onTabClick',
    value: function onTabClick(activeKey) {
      if (this.tabBar.props.onTabClick) {
        this.tabBar.props.onTabClick(activeKey);
      }
      this.setActiveKey(activeKey);
    }
  }, {
    key: 'onNavKeyDown',
    value: function onNavKeyDown(e) {
      var eventKeyCode = e.keyCode;
      if (eventKeyCode === _KeyCode2['default'].RIGHT || eventKeyCode === _KeyCode2['default'].DOWN) {
        e.preventDefault();
        var nextKey = this.getNextActiveKey(true);
        this.onTabClick(nextKey);
      } else if (eventKeyCode === _KeyCode2['default'].LEFT || eventKeyCode === _KeyCode2['default'].UP) {
        e.preventDefault();
        var previousKey = this.getNextActiveKey(false);
        this.onTabClick(previousKey);
      }
    }
  }, {
    key: 'setActiveKey',
    value: function setActiveKey(activeKey) {
      if (this.state.activeKey !== activeKey) {
        if (!('activeKey' in this.props)) {
          this.setState({
            activeKey: activeKey
          });
        }
        this.props.onChange(activeKey);
      }
    }
  }, {
    key: 'getNextActiveKey',
    value: function getNextActiveKey(next) {
      var activeKey = this.state.activeKey;
      var children = [];
      _react2['default'].Children.forEach(this.props.children, function (c) {
        if (c && !c.props.disabled) {
          if (next) {
            children.push(c);
          } else {
            children.unshift(c);
          }
        }
      });
      var length = children.length;
      var ret = length && children[0].key;
      children.forEach(function (child, i) {
        if (child.key === activeKey) {
          if (i === length - 1) {
            ret = children[0].key;
          } else {
            ret = children[i + 1].key;
          }
        }
      });
      return ret;
    }
  }, {
    key: 'render',
    value: function render() {
      var _classnames;

      var props = this.props;
      var prefixCls = props.prefixCls,
          tabBarPosition = props.tabBarPosition,
          className = props.className,
          renderTabContent = props.renderTabContent,
          renderTabBar = props.renderTabBar;

      var cls = (0, _classnames3['default'])((_classnames = {}, (0, _defineProperty3['default'])(_classnames, prefixCls, 1), (0, _defineProperty3['default'])(_classnames, prefixCls + '-' + tabBarPosition, 1), (0, _defineProperty3['default'])(_classnames, className, !!className), _classnames));

      this.tabBar = renderTabBar();
      var contents = [_react2['default'].cloneElement(this.tabBar, {
        prefixCls: prefixCls,
        key: 'tabBar',
        onKeyDown: this.onNavKeyDown,
        tabBarPosition: tabBarPosition,
        onTabClick: this.onTabClick,
        panels: props.children,
        activeKey: this.state.activeKey
      }), _react2['default'].cloneElement(renderTabContent(), {
        prefixCls: prefixCls,
        tabBarPosition: tabBarPosition,
        activeKey: this.state.activeKey,
        destroyInactiveTabPane: props.destroyInactiveTabPane,
        children: props.children,
        onChange: this.setActiveKey,
        key: 'tabContent'
      })];
      if (tabBarPosition === 'bottom') {
        contents.reverse();
      }
      return _react2['default'].createElement(
        'div',
        {
          className: cls,
          style: props.style
        },
        contents
      );
    }
  }]);
  return Tabs;
}(_react2['default'].Component);

exports['default'] = Tabs;


Tabs.propTypes = {
  destroyInactiveTabPane: _propTypes2['default'].bool,
  renderTabBar: _propTypes2['default'].func.isRequired,
  renderTabContent: _propTypes2['default'].func.isRequired,
  onChange: _propTypes2['default'].func,
  children: _propTypes2['default'].any,
  prefixCls: _propTypes2['default'].string,
  className: _propTypes2['default'].string,
  tabBarPosition: _propTypes2['default'].string,
  style: _propTypes2['default'].object,
  activeKey: _propTypes2['default'].string,
  defaultActiveKey: _propTypes2['default'].string
};

Tabs.defaultProps = {
  prefixCls: 'rc-tabs',
  destroyInactiveTabPane: false,
  onChange: noop,
  tabBarPosition: 'top',
  style: {}
};

Tabs.TabPane = _TabPane2['default'];
module.exports = exports['default'];